/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "main.h"
void SystemInit()
{}
/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
md_i2c_init_t g_i2c_h;
g_eeprom_read_write_t g_eeprom;

char g_send_buf[] = "eeprom example!";
uint32_t g_send_len = sizeof(g_send_buf);
char g_recv_buf[32];

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
/*The main function*/
int main(void)
{
    /*Configure the system clock*/
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);

    /*Initialize the SysTick interrupt*/
    md_init_1ms_tick();

    /*I2C clock can make*/
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    mcu_usart_init();
    /*I2C initialization*/
    initialize_i2c_master();

    /*I2C can make*/
    MD_I2C_ENABLE(I2C0);

    g_eeprom.g_slave_addr = SLAVE_ADDR;
    g_eeprom.g_mem_addr = MEM_ADDR;

    g_eeprom.g_finish = RESET;
    g_eeprom.g_buf = g_send_buf;
    g_eeprom.g_size = g_send_len;
    g_eeprom.g_read_or_write = I2C_REQUEST_WRITE;

    /*Generate the start bit, automatically switch to host mode*/
    md_i2c_generate_start_condition(I2C0);

    while (g_eeprom.g_finish != SET);

    g_eeprom.g_finish = RESET;
    g_eeprom.g_buf = g_recv_buf;
    g_eeprom.g_size = g_send_len;
    g_eeprom.g_read_or_write = I2C_REQUEST_READ;

    /*Generate the start bit, automatically switch to host mode*/
    md_i2c_generate_start_condition(I2C0);

    while (g_eeprom.g_finish != SET);

    while (1);
}

/**
  * @} Examples_I2C
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
