/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"
#include <stdio.h>
#include <string.h>
#include "i2c.h"
#include "usart.h"
/* Exported Types ------------------------------------------------------------ */
/**
  * @brief Master Transmission Request Direction Definition
  */
typedef enum
{
    I2C_REQUEST_WRITE = 0x00,
    I2C_REQUEST_READ  = 0x01,
} read_write_order_t;

/**
  *@brief eeprom_read_write
  */

typedef struct g_eeprom_read_write_t
{
    uint32_t g_slave_addr ;
    uint32_t g_mem_addr;
    char *g_buf;
    uint32_t g_size;
    read_write_order_t g_read_or_write;
    flag_status_t g_finish;
} g_eeprom_read_write_t;


/* Exported Macros ----------------------------------------------------------- */
/**
  * @brief I2C gpio settings
  */
#define I2C0_SCL_PORT   GPIOB
#define I2C0_SCL_PIN    MD_GPIO_PIN_1      /* I2CSCL */
#define I2C0_SDA_PORT   GPIOB
#define I2C0_SDA_PIN    MD_GPIO_PIN_0      /* I2CSDA */

/**
  * @brief Slave settings
  */
#define SLAVE_OWN_ADDRESS  0x5A /* This value is a left shift of a real 7 bits of a slave address
                                   value which can find in a Datasheet as example: b0101101
                                   mean in uint8_t equivalent at 0x2D and this value can be
                                   seen in the ADDR1 register in bits ADD[1:7] */


#define SLAVE_ADDR  0xA0    /*Definition from the machine address*/
#define MEM_ADDR    0x00    /*Define the machine from the initial memory address*/

/* Exported Variables -------------------------------------------------------- */
extern char g_send_buf[];
extern uint32_t g_send_len;
extern char g_recv_buf[32];
extern g_eeprom_read_write_t g_eeprom;
/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

__STATIC_INLINE void md_i2c_clear_flag_addr(I2C_TypeDef *i2c)
{
    __IO uint32_t tmpreg;
    tmpreg = i2c->STAT1;
    (void) tmpreg;
    tmpreg = i2c->STAT2;
    (void) tmpreg;
}

__STATIC_INLINE void md_i2c_clear_flag_stop(I2C_TypeDef *i2c)
{
    __IO uint32_t tmpreg;
    tmpreg = i2c->STAT1;
    (void) tmpreg;

    SET_BIT(i2c->CON1, I2C_CON1_PEN_MSK);
}

#endif     /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
