/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples_I2C
  * @{
  */
/* Public Variables ---------------------------------------------------------- */
md_i2c_init_t g_i2c_h;
/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}

/*From machine mode communication pins initialization function*/
void i2c_pin_init(void)
{
    md_gpio_init_t a;

    /*From the machine initialization SCL pins*/
    a.mode = MD_GPIO_MODE_OUTPUT;
    a.odos = MD_GPIO_OPEN_DRAIN;    /*Open drain output*/
    a.pupd = MD_GPIO_PUSH_UP;
    a.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    a.flt  = MD_GPIO_FILTER_DISABLE;
    a.type = MD_GPIO_TYPE_CMOS;
    a.func = MD_GPIO_FUNC_3;
    md_gpio_init(I2C_SCL_PORT, I2C_SCL_PIN, &a);

    /*From the machine initialization SDA pin*/
    a.mode = MD_GPIO_MODE_OUTPUT;
    a.odos = MD_GPIO_OPEN_DRAIN;    /*Open drain output*/
    a.pupd = MD_GPIO_PUSH_UP;
    a.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    a.flt  = MD_GPIO_FILTER_DISABLE;
    a.type = MD_GPIO_TYPE_CMOS;
    a.func = MD_GPIO_FUNC_3;
    md_gpio_init(I2C_SDA_PORT, I2C_SDA_PIN, &a);

    return;
}

/*I2C initialization function*/
void initialize_i2c_slave(void)
{
    /*Will the I2C initialization structure is set to the default values*/
    md_i2c_struct_init(&g_i2c_h);

    /*User configuration I2C*/
    g_i2c_h.addr_mode = MD_I2C_ADDR_7BIT;
    g_i2c_h.clk_speed = 400000;
    g_i2c_h.dual_addr = MD_I2C_DUALADDR_DISABLE;
    g_i2c_h.duty = MD_I2C_DUTYCYCLE_16_9;
    g_i2c_h.general_call = MD_I2C_GENERALCALL_DISABLE;
    g_i2c_h.stretch = MD_I2C_STRETCH_ENABLE;
    g_i2c_h.own_addr1 = 0x2D << 1;
    /*Initialize the I2C*/
    md_i2c_init(I2C0, &g_i2c_h);

    /*Interrupt priority level*/
    NVIC_SetPriority(I2C0_IRQn, 0);
    NVIC_EnableIRQ(I2C0_IRQn);
}

/*The main function*/
int main(void)
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /*Pin initialization of communication*/
    i2c_pin_init();

    /*I2C initialization*/
    initialize_i2c_slave();

    /*The interrupt enable*/
    md_i2c_enable_it_evt(I2C0);
    md_i2c_enable_it_err(I2C0);

    /*I2C can make*/
    MD_I2C_ENABLE(I2C0);

    /*Make can receive complete automatic reply*/
    md_i2c_enable_ack(I2C0);

    while (1);
}

/**
  * @} Examples_I2C
  */

/**
  * @} Projects_Examples_MD
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
