/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"
#include <stdio.h>
#include <string.h>

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Macros ----------------------------------------------------------- */
#define I2C_SCL_PORT    GPIOA
#define I2C_SCL_PIN MD_GPIO_PIN_10
#define I2C_SDA_PORT    GPIOA
#define I2C_SDA_PIN MD_GPIO_PIN_11

#define MD_I2C_DIRECTION_WRITE  I2C_STAT2_TRF_MSK       /*!< Bus is in write transfer */
#define MD_I2C_DIRECTION_READ   0x00000000U         /*!< Bus is in read transfer */
/* Exported Functions -------------------------------------------------------- */
__STATIC_INLINE void md_i2c_clear_flag_addr(I2C_TypeDef *i2c)
{
    __IO uint32_t tmpreg;
    tmpreg = i2c->STAT1;
    (void) tmpreg;
    tmpreg = i2c->STAT2;
    (void) tmpreg;
}

__STATIC_INLINE void md_i2c_clear_flag_stop(I2C_TypeDef *i2c)
{
    __IO uint32_t tmpreg;
    tmpreg = i2c->STAT1;
    (void) tmpreg;

    SET_BIT(i2c->CON1, I2C_CON1_PEN_MSK);
}
__STATIC_INLINE void md_i2c_clear_smbus_flag_alert(I2C_TypeDef *i2c)
{
    CLEAR_BIT(i2c->STAT1, I2C_STAT1_SMBALARM_MSK);
}
/**
  * @brief Slave settings
  */
#define SLAVE_OWN_ADDRESS  0x5A /* This value is a left shift of a real 7 bits of a slave address
                                   value which can find in a Datasheet as example: b0101101
                                   mean in uint8_t equivalent at 0x2D and this value can be
                                   seen in the ADDR1 register in bits ADD[1:7] */
/*Real ֘ address 0 x2d*/

/**
  * @brief Master Transmission Request Direction Definition
  */
#define I2C_REQUEST_WRITE       0x00
#define I2C_REQUEST_READ        0x01

#endif  /* __MAIN_H__ */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
