/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}
/**
  * @brief  Initialize GPIO for triger io and single pluse funtion
  * @param  None
  * @retval None
  */
static void init_gpio(void)
{
    md_gpio_init_t gpio_init;

    md_gpio_init_struct(&gpio_init);
    gpio_init.func = MD_GPIO_FUNC_5;
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    md_gpio_init(CH1_PORT, CH1_PIN, &gpio_init);

    md_gpio_init_struct(&gpio_init);
    gpio_init.func = MD_GPIO_FUNC_1;
    gpio_init.mode = MD_GPIO_MODE_INPUT;
    gpio_init.flt = MD_GPIO_FILTER_DISABLE;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    gpio_init.pupd = MD_GPIO_FLOATING;
    md_gpio_init(TRIGER_PORT, TRIGER_PIN, &gpio_init);

    md_gpio_init_struct(&gpio_init);
    gpio_init.func = MD_GPIO_FUNC_4;
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    md_gpio_init(PIS_PORT, PIS_PIN, &gpio_init);

}

/**
  * @brief  Initialize PIS for IO triger GP16C2T00 enable
  * @param  None
  * @retval None
  */
void init_pis(void)
{
    md_pis_init_t pis_init;

    memset(&pis_init, 0, sizeof(md_pis_init_t));
    pis_init.p_src = MD_PIS_GPIOA_PIN8;    /* production signal */
    pis_init.c_trig = MD_PIS_CH2_GP16C2T0_ITR0; /* comsumer signal */ /*Choose three pis channels*/
    md_pis_enable_ch2_output(PIS);
    md_pis_init(&pis_init);

}

/**
  * @brief:  Initialize GP16C2T0 to timely overflow funtion
  * @param:  None
  * @retval: None
  */
static void init_timer(void)
{

    /* enable GP16C2T0 */
    md_timer_base_init_t gp16c2t_init;
    md_timer_oc_init_t oc_init;

    md_timer_base_struct_init(&gp16c2t_init);
    gp16c2t_init.prescaler = 32 - 1;     /* clk_count: 1MHz */
    gp16c2t_init.clk_div = MD_TIMER_CLOCK_DIV1;  /* working clock of dead time and filter */
    gp16c2t_init.mode = MD_TIMER_CNT_MODE_UP;  /* count mode is up count */
    gp16c2t_init.period = 10000 - 1;        /* period is 10000 count clock */
    gp16c2t_init.re_cnt = 0;                /* no repeat count */
    md_timer_base_set_config(GP16C2T0, &gp16c2t_init);

    /* Preload register on CCVAL1 enabled */
    md_timer_set_output_compare1_preload_enable_ch1opren(GP16C2T0, ENABLE);

    md_timer_oc_struct_init(&oc_init);
    oc_init.ocstate = MD_TIMER_OCSTATE_ENABLE;    /* enable CHxO compare output */
    oc_init.oc_mode = MD_TIMER_OC_MODE_PWM2;      /* compare output mode is PWM2 */
    oc_init.oc_polarity = MD_TIMER_OC_POLARITY_HIGH;    /* CHxO compare output polarity is high */
    oc_init.ocn_polarity = MD_TIMER_OCN_POLARITY_HIGH;  /* CHxON compare output polarity is high */
    oc_init.oc_idle = MD_TIMER_OC_IDLE_RESET;    /* CHxO idle is low */
    oc_init.ocn_idle = MD_TIMER_OCN_IDLE_RESET;    /* CHxON idle is low */
    oc_init.pulse = 5000 - 1;    /* CH1 compare value is 5000 - 1 */
    md_timer_oc_init(GP16C2T0, MD_TIMER_CHANNEL_1, &oc_init);

    md_timer_set_slave_mode_smods(GP16C2T0, 6);        /* 0x6: Trigger Mode */
    md_timer_set_slave_trigger_tssel(GP16C2T0, 0);     /* 0x0: Internal Trigger 0 */

    md_timer_enable_cc1it_interrupt(GP16C2T0);   /* enable CC1 interrupt request */
    md_timer_enable_uit_interrupt(GP16C2T0);     /* update interrupt request */

    md_mcu_irq_config(GPTIMC0_IRQn, 0, ENABLE);  /* enable NVIC GP16C2T0 interrupt */

    md_timer_enable_onepulse_spmen(GP16C2T0);           /* enable single pulse */
    md_timer_set_main_output_enable(GP16C2T0, 1);       /* enable output */

}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* Initialize pin */
    init_gpio();
    /* Initialize pis */
    init_pis();
    /* Initialize timer */
    init_timer();

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
