/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}
/**
  * @brief  Initialize GPIO for PWM funtion
  * @param  None
  * @retval None
  */
static void init_gpio(void)
{
    md_gpio_init_t gpio_init;

    md_gpio_init_struct(&gpio_init);
    gpio_init.func = MD_GPIO_FUNC_5;
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos = MD_GPIO_PUSH_PULL;
    gpio_init.pupd = MD_GPIO_FLOATING;
    md_gpio_init(CH1_PORT, CH1_PIN, &gpio_init);
    md_gpio_init(CH1N_PORT, CH1N_PIN, &gpio_init);
    md_gpio_init(CH2_PORT, CH2_PIN, &gpio_init);

    md_gpio_init_struct(&gpio_init);
    gpio_init.func = MD_GPIO_FUNC_7;
    gpio_init.mode = MD_GPIO_MODE_INPUT;
    gpio_init.pupd = MD_GPIO_FLOATING;
    md_gpio_init(BKIN_PORT, BKIN_PIN, &gpio_init);
}

/**
  * @brief:  Initialize GP16C2T1 to timely overflow funtion
  * @param:  None
  * @retval: None
  */
static void init_timer(void)
{
    md_timer_base_init_t ad16c4t_init;
    md_timer_oc_init_t oc_init;
    md_timer_break_dead_time_t brake_setting;

    md_timer_base_struct_init(&ad16c4t_init);   /* initialize the ad16c4t_init  */
    ad16c4t_init.prescaler = 32 - 1;           /* clk_count: 1MHz */
    ad16c4t_init.clk_div = MD_TIMER_CLOCK_DIV1; /* working clock of dead time and filter */
    ad16c4t_init.mode = MD_TIMER_CNT_MODE_CENTER1; /* count mode is center1 */
    ad16c4t_init.period = 10000;             /* period is 10000 count clock */
    ad16c4t_init.re_cnt = 1 - 1;               /* no repeat count */
    md_timer_base_set_config(GP16C2T1, &ad16c4t_init);

    /* Preload register on CCVAL1/CCVAL2 enabled */
    md_timer_set_output_compare1_preload_enable_ch1opren(GP16C2T1, ENABLE);
    md_timer_set_output_compare2_preload_enable_ch2opren(GP16C2T1, ENABLE);

    /* initialize the ic_init  */
    md_timer_oc_struct_init(&oc_init);
    oc_init.ocstate = MD_TIMER_OCSTATE_ENABLE;    /* enable CHxO compare output */
    oc_init.ocnstate = MD_TIMER_OCSTATE_ENABLE;   /* enable CHxON compare output */
    oc_init.oc_mode = MD_TIMER_OC_MODE_PWM2;      /* compare output mode is PWM2 */
    oc_init.oc_polarity = MD_TIMER_OC_POLARITY_HIGH;    /* CHxO compare output polarity is high */
    oc_init.ocn_polarity = MD_TIMER_OCN_POLARITY_HIGH;  /* CHxON compare output polarity is high */
    oc_init.oc_idle = MD_TIMER_OC_IDLE_RESET;    /* CHxO idle is low */
    oc_init.ocn_idle = MD_TIMER_OCN_IDLE_RESET;    /* CHxON idle is low */
    oc_init.pulse = 1000 - 1;    /* CH1 compare value is 1000 - 1 */
    md_timer_oc_init(GP16C2T1, MD_TIMER_CHANNEL_1, &oc_init);
    oc_init.pulse = 3000 - 1;    /* CH2 compare value is 3000 - 1 */
    md_timer_oc_init(GP16C2T1, MD_TIMER_CHANNEL_2, &oc_init);

    brake_setting.off_run = ENABLE;        /* Enable off state in run mode */
    brake_setting.off_idle = ENABLE;       /* Enable off state in idle mode */
    brake_setting.lock_level = MD_TIMER_LOCK_LEVEL_OFF;  /* Lock level off */
    brake_setting.dead_time = 0xFF;     /* Dead time, [0x0, 0xFF] */
    brake_setting.break_state = ENABLE;    /* Break state */
    brake_setting.polarity = MD_TIMER_BREAK_POLARITY_LOW;    /* Break input polarity */
    brake_setting.auto_out = ENABLE;       /* Enalbe automatic output */
    timer_bdtr_init(GP16C2T1, &brake_setting);

    md_timer_enable_cc1it_interrupt(GP16C2T1);   /* enable CC1 interrupt request */
    md_timer_enable_cc2it_interrupt(GP16C2T1);   /* enable CC2 interrupt request */

    md_timer_enable_uit_interrupt(GP16C2T1);     /* update interrupt request */

    md_mcu_irq_config(GPTIMC1_IRQn, 1, ENABLE); /* enable NVIC GP16C2T1 interrupt */

    /* enable GP16C2T1 */
    md_timer_enable_counter_cnten(GP16C2T1);

}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /* Initialize pin */
    init_gpio();
    /* Initialize timer */
    init_timer();

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
