/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"


/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
md_dma_descriptor_t dma0_ctrl_base[8] __attribute__((aligned(128)));
md_dma_descriptor_t g_scatter_gather_ctrl[5];

char g_src1[] = "task1:hello world!\r\n";
char g_src2[] = "task2:hello world!\r\n";
char g_src3[] = "task3:hello world!\r\n";
char g_src4[] = "task4:hello world!\r\n";
char g_src5[] = "task5:hello world!\r\n";

/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Public Function ---------------------------------------------------------- */
void SystemInit(void)
{}

/* Private function prototypes ----------------------------------------------- */
void usart_init(void);

/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Test main function
  * @retval Status.
  */
void dma_init(void)
{
    md_dma_config_t dma_config;

    memset(&dma_config, 0x0, sizeof(md_dma_config_t));

    md_dma_enable();
    md_dma_set_ctrlbase((uint32_t)&dma0_ctrl_base);

    md_dma_config_struct(&dma_config);

    dma_config.channel = 0;
    dma_config.data_width = MD_DMA_DATA_SIZE_BYTE;
    dma_config.primary = DISABLE;
    dma_config.R_power = MD_DMA_R_POWER_1;
    dma_config.dst     = (void *)&USART0->DATA;
    dma_config.src     = g_src1;
    dma_config.dst_inc = MD_DMA_DATA_INC_NONE;
    dma_config.src_inc = MD_DMA_DATA_INC_BYTE;
    dma_config.size    = strlen(g_src1);
    dma_config.msel    = MD_DMA_MSEL_USART0;
    dma_config.msigsel = MD_DMA_MSIGSEL_USART_TXEMPTY;
    dma_config.burst   = ENABLE;
    dma_config.interrupt = DISABLE;
    dma_config.high_prio = ENABLE;

    md_dma_config_sg_alt_desc(&g_scatter_gather_ctrl[0], &dma_config, DISABLE);

    dma_config.src     = g_src2;
    dma_config.size    = strlen(g_src2);
    md_dma_config_sg_alt_desc(&g_scatter_gather_ctrl[1], &dma_config, DISABLE);

    dma_config.src     = g_src3;
    dma_config.size    = strlen(g_src3);
    md_dma_config_sg_alt_desc(&g_scatter_gather_ctrl[2], &dma_config, DISABLE);

    dma_config.src     = g_src4;
    dma_config.size    = strlen(g_src4);
    md_dma_config_sg_alt_desc(&g_scatter_gather_ctrl[3], &dma_config, DISABLE);

    dma_config.src     = g_src5;
    dma_config.size    = strlen(g_src5);
    md_dma_config_sg_alt_desc(&g_scatter_gather_ctrl[4], &dma_config, DISABLE);

    dma_config.channel = 0;
    dma_config.data_width = MD_DMA_DATA_SIZE_WORD;
    dma_config.primary = ENABLE;
    dma_config.R_power = MD_DMA_R_POWER_4;
    dma_config.dst     = (void *)&dma0_ctrl_base[0];
    dma_config.src     = g_scatter_gather_ctrl;
    dma_config.dst_inc = MD_DMA_DATA_INC_WORD;
    dma_config.src_inc = MD_DMA_DATA_INC_WORD;
    dma_config.size    = 5 * 4;
    dma_config.msel    = MD_DMA_MSEL_USART0;
    dma_config.msigsel = MD_DMA_MSIGSEL_USART_TXEMPTY;
    dma_config.burst   = ENABLE;
    dma_config.interrupt = DISABLE;
    dma_config.high_prio = DISABLE;

    md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_PER_SG_PRIMARY, &dma_config);

    md_dma_enable_channel(MD_DMA_CH_0);
    md_usart_enable_dma_req_tx(USART0);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{

    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Config usart */
    usart_init();
    md_usart_clear_flag_txc(USART0);

    memset(dma0_ctrl_base, 0x0, sizeof(dma0_ctrl_base));
    /* Config dma */
    dma_init();

    while (1)
    {
        /* strongly recommend to clear idle flag in main loop */
        if (md_usart_is_active_flag_idle(USART0))
            md_usart_clear_flag_idle(USART0);

        if (md_dma_is_active_flag_done(MD_DMA_CH_0))
        {
            md_dma_clear_flag_done(MD_DMA_CH_0);
            md_usart_clear_flag_txc(USART0);
            md_usart_disable_dma_req_tx(USART0);
            dma_init();
        }

        md_delay_1ms(1000);
    }
}

/**
  * @brief  USART initilization function
  * @retval Status.
  */
void usart_init()
{
    md_gpio_init_t gpio_init_s;
    md_usart_init_t usart_init_s;

    md_gpio_init_struct(&gpio_init_s);
    gpio_init_s.func = MD_GPIO_FUNC_3;
    gpio_init_s.mode = MD_GPIO_MODE_OUTPUT;
    md_gpio_init(USART0_TX_PORT, USART0_TX_PIN, &gpio_init_s);

    gpio_init_s.mode = MD_GPIO_MODE_INPUT;
    md_gpio_init(USART0_RX_PORT, USART0_RX_PIN, &gpio_init_s);

    md_usart_init_struct(&usart_init_s);
    md_usart_init(USART0, &usart_init_s);

    return;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
