/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

void SystemInit()
{

}
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

md_dma_descriptor_t dma0_ctrl_base[1 + 4] __attribute__((aligned(128)));

char g_src1[] = "task1: hello world!\r\n";
char g_src2[] = "task2: hello world!\r\n\r\n";

/* Private Constants --------------------------------------------------------- */


/* Private function prototypes ----------------------------------------------- */

void uart_init(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{

    md_dma_config_t dma_config;

    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    uart_init();

    memset(dma0_ctrl_base, 0x0, sizeof(dma0_ctrl_base));
    memset(&dma_config, 0x0, sizeof(md_dma_config_t));

    md_dma_enable();
    md_dma_set_ctrlbase((uint32_t)&dma0_ctrl_base);

    md_dma_config_struct(&dma_config);
    dma_config.channel = 0;
    dma_config.data_width = MD_DMA_DATA_SIZE_BYTE;
    dma_config.primary = DISABLE;
    dma_config.R_power = MD_DMA_R_POWER_1;
    dma_config.dst     = (void *)&USART0->DATA;
    dma_config.src     = g_src2;
    dma_config.dst_inc = MD_DMA_DATA_INC_NONE;
    dma_config.src_inc = MD_DMA_DATA_INC_BYTE;
    dma_config.size    = strlen(g_src2);
    dma_config.msel    = MD_DMA_MSEL_USART0;
    dma_config.msigsel = MD_DMA_MSIGSEL_USART_TXEMPTY;
    dma_config.burst   = ENABLE;
    dma_config.interrupt = ENABLE;

    md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_PINGPONG, &dma_config);

    dma_config.channel = 0;
    dma_config.data_width = MD_DMA_DATA_SIZE_BYTE;
    dma_config.primary = ENABLE;
    dma_config.R_power = MD_DMA_R_POWER_1;
    dma_config.dst     = (void *)&USART0->DATA;
    dma_config.src     = g_src1;
    dma_config.dst_inc = MD_DMA_DATA_INC_NONE;
    dma_config.src_inc = MD_DMA_DATA_INC_BYTE;
    dma_config.size    = strlen(g_src1);
    dma_config.msel    = MD_DMA_MSEL_USART0;
    dma_config.msigsel = MD_DMA_MSIGSEL_USART_TXEMPTY;
    dma_config.burst   = ENABLE;
    dma_config.interrupt = ENABLE;

    md_dma_clear_flag_done(MD_DMA_CH_0);
    md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_PINGPONG, &dma_config);

    __NVIC_EnableIRQ(DMA_IRQn);

    md_dma_enable_channel(MD_DMA_CH_0);
    md_usart_enable_dma_req_tx(USART0);

    while (1)
    {
        /* strongly recommend to clear idle flag in main loop */
        if (md_usart_is_active_flag_idle(USART0))
            md_usart_clear_flag_idle(USART0);
    }
}

void uart_init()
{
    md_gpio_init_t gpio_init_s;
    md_usart_init_t uart_init_s;

    md_gpio_init_struct(&gpio_init_s);

    gpio_init_s.func = MD_GPIO_FUNC_3;
    gpio_init_s.mode = MD_GPIO_MODE_OUTPUT;
    md_gpio_init(GPIOA, MD_GPIO_PIN_13, &gpio_init_s);

    gpio_init_s.mode = MD_GPIO_MODE_INPUT;
    md_gpio_init(GPIOA, MD_GPIO_PIN_14, &gpio_init_s);

    md_usart_init_struct(&uart_init_s);
    md_usart_init(USART0, &uart_init_s);
}

void dma_uart_pingpong_config_struct(uint8_t channel, void *src, uint16_t length)
{
    md_dma_descriptor_t *desc;

    desc = (md_dma_descriptor_t *)(DMA0->CTRLBASE) + channel;

    if (desc->ctrl.cycle_ctrl != 0)
        desc = (md_dma_descriptor_t *)(DMA0->ALTCTRLBASE) + channel;

    desc->ctrl.cycle_ctrl = MD_DMA_CYCLE_CTRL_PINGPONG;

    desc->src = (void *)((uint32_t)src + ((length - 1) << desc->ctrl.src_size));
    desc->ctrl.n_minus_1 = length - 1;
}

void DMA_Handler()
{
    static uint8_t src_index = 0;

    if (md_dma_is_active_flag_done(MD_DMA_CH_0) && md_dma_is_enabled_it_done(MD_DMA_CH_0))
    {
        if (src_index == 0)
            dma_uart_pingpong_config_struct(0, g_src1, strlen(g_src1));
        else
            dma_uart_pingpong_config_struct(0, g_src2, strlen(g_src2));

        src_index = (src_index + 1) & 0x01;

        md_dma_clear_flag_done(MD_DMA_CH_0);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
