/**********************************************************************************
 *
 * @file    main.h
 * @brief   header file of main.c
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"
#include <stdio.h>
#include <string.h>

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#define USART0_TX_PORT  GPIOA
#define USART0_TX_PIN   MD_GPIO_PIN_13
#define USART0_RX_PORT  GPIOA
#define USART0_RX_PIN   MD_GPIO_PIN_14

#define BUF_LEN     10

/* Exported Variables -------------------------------------------------------- */
extern uint8_t  g_dir_flag;
extern uint8_t  g_complete_cnt;
extern uint8_t  g_tx_buf[BUF_LEN];
extern uint8_t  g_rx_buf[BUF_LEN];

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
void dma_send_tx(DMA_TypeDef *DMAx, USART_TypeDef *USARTx, uint8_t *buf, uint16_t size, uint8_t channel);
void dma_recv_rx(DMA_TypeDef *DMAx, USART_TypeDef *USARTx, uint8_t *buf, uint16_t size, uint8_t channel);

#endif    /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
