/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Public Variables ---------------------------------------------------------- */
volatile uint32_t g_result = 0;

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
void usart_init(void);
/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{
    md_crc_init_t crc_init;

    uint8_t i = 0U;
    uint8_t crc_buf[8] = {1U, 2U, 3U, 4U, 5U, 6U, 7U, 8U};
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    usart_init();
    printf("CRC demo\r\n");
    /* Init CRC */
    md_crc_init_struct(&crc_init);

    crc_init.mode = MD_CRC_MODE_32;
    crc_init.len = MD_CRC_DATASIZE_8;
    crc_init.order = MD_CRC_BYTORD_LOW;
    crc_init.seed = 0xFFFFFFFF;
    crc_init.chs_inv = ENABLE;
    crc_init.chs_rev = ENABLE;
    crc_init.data_inv = DISABLE;
    crc_init.data_rev = ENABLE;
    md_crc_init(&crc_init);

    for (i = 0; i < 8; i++)
        md_crc_write_data(CRC, crc_buf[i]);

    g_result = md_crc_get_check_result(CRC);
    printf("CRC-32 result: 0x%08X\r\n", g_result);/* Init CRC */

    /* Init CRC */
    md_crc_init_struct(&crc_init);

    crc_init.mode = MD_CRC_MODE_32;
    crc_init.len = MD_CRC_DATASIZE_8;
    crc_init.order = MD_CRC_BYTORD_LOW;
    crc_init.seed = 0xFFFFFFFF;
    crc_init.chs_inv = DISABLE;
    crc_init.chs_rev = DISABLE;
    crc_init.data_inv = DISABLE;
    crc_init.data_rev = DISABLE;
    md_crc_init(&crc_init);

    for (i = 0; i < 8; i++)
        md_crc_write_data(CRC, crc_buf[i]);

    g_result = md_crc_get_check_result(CRC);
    printf("CRC-32/MPEG-2 result: 0x%08X\r\n", g_result);
    printf("\r\n");

    while (1);
}
void usart_gpio_init()
{

    md_gpio_init_t g_gpio_init_s;

    md_gpio_init_struct(&g_gpio_init_s);

    g_gpio_init_s.mode = MD_GPIO_MODE_OUTPUT;
    g_gpio_init_s.func = MD_GPIO_FUNC_3;

    md_gpio_init(USART_PORT, USART_TX_PIN, &g_gpio_init_s);

    g_gpio_init_s.mode = MD_GPIO_MODE_INPUT;
    md_gpio_init(USART_PORT, USART_RX_PIN, &g_gpio_init_s);
}

void usart_init()
{

    md_usart_init_t g_usart_init_s;

    md_cmu_enable_perh_usart0();

    usart_gpio_init();

    md_usart_init_struct(&g_usart_init_s);

    md_usart_init(USART0, &g_usart_init_s);
}

int fputc(int c, FILE *f)
{
    while ((READ_BIT(USART0->STAT, USART_STAT_TXEMPIF_MSK)) != USART_STAT_TXEMPIF_MSK);

    USART0->DATA = (uint8_t)c;
    return c;
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
