/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
void SystemInit()
{}
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uint32_t g_sysclk;
uint32_t g_hclk;
uint32_t g_pclk;
uint32_t current_clk = 0x0;
uint32_t clk_change_reason = 0x0;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Init clock out pin(HSCO PA13)
  * @retval None
  */
void md_hsco_pin_init(void)
{
    md_gpio_init_t x;
    /* Initialize pin */
    x.mode  = MD_GPIO_MODE_OUTPUT;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.pupd  = MD_GPIO_FLOATING;
    x.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_4;
    md_gpio_init(GPIOA, MD_GPIO_PIN_13, &x);
}


/**
  * @brief  Test main function
  * @retval Status.
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HOSC, 12000000);

    SYSCFG_UNLOCK();
    md_cmu_set_hosc_region(3);  /* 3: 8-16MHz */
    md_cmu_enable_hosc_safe();

    md_cmu_set_hsco_div(7);   /* 7: HSC / 128 */
    md_cmu_set_hsco_type(4);  /* 4: SYSCLK */
    md_cmu_enable_hsco();     /* Enable HSC output */

    /* Enable interrupt */
	md_cmu_clear_flag_hosc_str();
	md_cmu_clear_flag_hosc_stp();
    md_cmu_enable_hosc_str_interrupt();
    md_cmu_enable_hosc_stp_interrupt();
    /* md_cmu_enable_hosc_nmi_interrupt(); */

    /* set the clock divider */
    md_cmu_set_sysclk_div(0x0); /* 0x0: Fclk / 1 */
    md_cmu_set_pclk_div(0x0);   /* 0x0: Fclk / 1 */

    /* get current clock */
    g_sysclk = md_cmu_get_sys_clock();
    g_hclk = md_cmu_get_hclk_clock();
    g_pclk = md_cmu_get_pclk_clock();
	
	/* config HRC clock as 16M */
	MODIFY_REG(CMU->CFGR, CMU_CFGR_HRCFSW_MSK, 1 << CMU_CFGR_HRCFSW_POSS);
	/* enable HRC */
	SET_BIT(CMU->CLKENR, CMU_CLKENR_HRCEN_MSK);
	/* Enable ALL peripheral */
    md_cmu_enable_perh_all(); 
	
    SYSCFG_LOCK();

    /* Initialize high speed clock output gpio (HSCO PA13) */
    md_hsco_pin_init();
	current_clk = (CMU->CSR & 0x300) >> 8;
	
    /* Initialize for usart print */
	md_init_1ms_tick();
	mcu_usart_init();
	
	/* Enable mcu irq */
    md_mcu_irq_config(CMU_IRQn, 0, ENABLE);  /* enable CMU IRQ */
	
	/* Print initial information of HRC */
	printf("current frequency level of HRC: 0x%.2x\r\n", (CMU->CFGR & 0x03000000) >> 24);
	
    while (1)
    {
		switch((CMU->CSR & 0x300) >> 8)
		{
			case 0x01:
				printf("current clock is HRC, frequency level : 0x%.2x\r\n", (CMU->CFGR & 0x03000000) >> 24);
				break;
			
			case 0x02:
				printf("current clock is LRC\r\n");
				break;
			
			case 0x03:
				printf("current clock is HOSC\r\n");
				break;
			
			default:
				printf("error\r\n");
				break;
		}
		
		if ((current_clk != ((CMU->CSR & 0x300) >> 8)) || (clk_change_reason != 0))
		{
			printf("clock source has changed, change reason: 0x%.2x\r\n", clk_change_reason);
		}
		
		md_delay_1ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
