/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Hardfault IRQ handler, already defined in startup file
  * @retval None
  */

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/**
  * @brief  CMU IRQ handler
  * @retval None
  */
void CMU_Handler(void)
{
    if ((md_cmu_is_enabled_hosc_stp_interrupt()) && (md_cmu_is_active_flag_hosc_stp()))
    {
        SYSCFG_UNLOCK();
        md_cmu_clear_flag_hosc_stp();
        SYSCFG_LOCK();
        /* system rescue code in hosc fault  */
		/* Change to HRC 32M */
		md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
		
		/* update clock change reason */
		clk_change_reason |= 0x01;
		
		/* reconfig systick and uasrt */
		md_init_1ms_tick();
		mcu_usart_init();
    }

    if ((md_cmu_is_enabled_hosc_str_interrupt()) && (md_cmu_is_active_flag_hosc_str()))
    {
        SYSCFG_UNLOCK();
        md_cmu_clear_flag_hosc_str();
		/* reconfig hosc */
		md_cmu_clock_config(MD_CMU_CLOCK_HOSC, 12000000);
		md_cmu_set_sysclk_div(0x0); 
		md_cmu_set_pclk_div(0x0); 
        SYSCFG_LOCK();
		
		/* update clock change reason */
		clk_change_reason |= 0x02;
		
		/* reconfig systick and uasrt */
		md_init_1ms_tick();
		mcu_usart_init();
	}
    return;
}

/**
  * @brief  NMI handler
  * @retval None
  */
void NMI_Handler(void)
{
    if ((md_cmu_is_enabled_hosc_nmi_interrupt()) && (md_cmu_is_active_flag_hosc_stp()))
    {
        SYSCFG_UNLOCK();
        md_cmu_clear_flag_hosc_stp();
        SYSCFG_LOCK();
        /* system rescue code in hosc fault  */
		/* Change to HRC 32M */
		md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
		
		/* update clock change reason */
		clk_change_reason |= 0x10;
		
		/* reconfig systick and uasrt */
		md_init_1ms_tick();
		mcu_usart_init();
    }
	
    if ((md_cmu_is_enabled_hosc_nmi_interrupt()) && (md_cmu_is_active_flag_hosc_str()))
    {
        SYSCFG_UNLOCK();
        md_cmu_clear_flag_hosc_str();
		/* reconfig hosc */
		md_cmu_clock_config(MD_CMU_CLOCK_HOSC, 12000000);
		md_cmu_set_sysclk_div(0x0); 
		md_cmu_set_pclk_div(0x0); 
        SYSCFG_LOCK();
		
		/* update clock change reason */
		clk_change_reason |= 0x20;
		
		/* reconfig systick and uasrt */
		md_init_1ms_tick();
		mcu_usart_init();
    }

    return;
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
