/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{

}

/**
  * @brief  Initialize TOGGLE IO.
  * @param  None
  * @retval None
  */
static void init_gpio(void)
{
    md_gpio_init_t gpio_init;
    /* Initialize TOGGLE IO as output */
    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.func = MD_GPIO_FUNC_1;      /* GPIO function 1 */
    gpio_init.mode = MD_GPIO_MODE_OUTPUT; /* output */
    gpio_init.odos = MD_GPIO_PUSH_PULL;   /* push pull */
    gpio_init.pupd = MD_GPIO_FLOATING;    /* no pull up and pull donw */
    md_gpio_init(TOGGLE_PORT, TOGGLE_PIN, &gpio_init);
}

/**
  * @brief:  Initialize BS16TN to timely overflow funtion
  * @param:  None
  * @retval: None
  */
static void init_timer(void)
{
    md_timer_base_init_t bs16tn_init;

    md_timer_base_struct_init(&bs16tn_init);   /* initialize the bs16tn_init  */
    bs16tn_init.prescaler = 32 - 1;           /* clk_count: 1MHz */
    bs16tn_init.mode = MD_TIMER_CNT_MODE_UP;   /* count up */
    bs16tn_init.period = 10000 - 1;             /* period is 10000 count clock */
    bs16tn_init.re_cnt = 1 - 1;               /* 0 repeat count */
    md_timer_base_set_config(BS16TN, &bs16tn_init);

    md_timer_enable_uit_interrupt(BS16TN);    /* enable updata interrupt */

    /* Set priority for BSTIM0_IRQn */
    NVIC_SetPriority(BSTIM0_IRQn, 0);

    /* Enable BSTIM0_IRQn */
    NVIC_EnableIRQ(BSTIM0_IRQn);

    /* enable BS16TN */
    md_timer_enable_counter_cnten(BS16TN);

}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{

    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();
    /*Initialize the gpio*/
    init_gpio();

    /*Initialize timer_BS16TN*/
    init_timer();

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
