/**********************************************************************************
 *
 * @file    main.c
 * @brief   4 conversion C file
 *
 * @date    18 Jan. 2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          18 Jan. 2022    Lisq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
md_adc_init_t   g_adc_init;

/* Public Variables ---------------------------------------------------------- */

/** @addtogroup Public_Function
  * @{
  */


/* Private Function ---------------------------------------------------------- */
void SystemInit()
{
}

/**
  * @brief  Configure the ADC Pins.
  * @param  None
  * @retval None
  */
void gpio_pin_g_config(void)
{
    md_gpio_init_t x;
    md_gpio_init_struct(&x);

    /* Initialize adc gpio pin */
    x.mode  = MD_GPIO_MODE_CLOSE;
    x.pupd  = MD_GPIO_FLOATING;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.odrv = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_0;

    md_gpio_init(ADC_CHANNEL0_GPIO_PORT, ADC_CHANNEL0_PIN, &x);

    return;
}

/**
  * @brief  Configure the ADC.
  * @param  None
  * @retval None
  */
void adc_base_g_config(void)
{
    md_adc_struct_init(&g_adc_init);
    /* Set ADC Base Configuration:  */
    g_adc_init.align    = MD_ADC_DATAALIGN_RIGHT;       /* Specifies ADC data alignment */
    g_adc_init.data_bit = MD_ADC_CONV_BIT_12;
    g_adc_init.div      = MD_ADC_CKDIV_32;              /* ADCCLK divider */
    g_adc_init.n_ref    = MD_ADC_NEG_REF_VSS;
    g_adc_init.p_ref    = MD_ADC_POS_REF_VDD;           /* The positive reference voltage*/
    md_adc_init(ADC0, &g_adc_init);

    /* Set ADC group injected conversion trigger:independent or from ADC group REG */
    md_adc_auto_inserted_conversion_enable_iauto(ADC0);

    /* Config the NCHE FALG mode */
    md_adc_set_eoc_selection_nchesel(ADC0, MD_ADC_NCHESEL_MODE_ALL);
    /*Enable ADC sequencers scan mode*/
    md_adc_scan_mode_enable_scanen(ADC0);
    /* Set ADC continuous conversion mode on ADC group REG.*/
    md_adc_continuous_conversion_enable_cm(ADC0);

    /* Set ADC group REG sequencer length and scan direction,ADC conversion 1 channel */
    md_adc_set_normal_channel_length_nsl(ADC0, MD_ADC_NCH_NR_1);
    /* Set ADC group INJ sequencer length and scan direction,ADC conversion 3 channel */
    md_adc_set_insert_channel_length_isl(ADC0, MD_ADC_ICH_NR_3);
    /*Set ADC group sequence: channel on the selected scan sequence rank.*/
    md_adc_set_normal_1st_conv_ns1(ADC0, MD_ADC_CHANNEL_0);
    md_adc_set_insert_1st_conv_is1(ADC0, MD_ADC_CHANNEL_0);
    md_adc_set_insert_2st_conv_is2(ADC0, MD_ADC_CHANNEL_0);
    md_adc_set_insert_3st_conv_is3(ADC0, MD_ADC_CHANNEL_0);

    /* Config sample time */
    md_adc_set_smpt1_cht(ADC0, MD_ADC_SAMPLETIME_15, MD_ADC_CHANNEL_0);

    /* Set priority for ADC_IRQn */
    NVIC_SetPriority(ADC0_IRQn, 0);
    /* Enable ADC_IRQn */
    NVIC_EnableIRQ(ADC0_IRQn);

    md_adc_inserted_channel_interrupt_enable_icheie(ADC0);

    return;
}

/**
  * @brief  Test main function
  * @retval Status.
  */
int main(void)
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Enable the selected ADC instance.*/
    md_adc_converter_enable_adcen(ADC0);
    /* Disable the selected ADC instance.*/
    md_adc_converter_disable_adcen(ADC0);

    /* Pin Configuration */
    gpio_pin_g_config();
    /* ADC Base Feature Configuration */
    adc_base_g_config();

    /*Enable the selected ADC instance.*/
    md_adc_converter_enable_adcen(ADC0);

    /* Enable ADC group REG conversion trigger source internal (SW start)*/
    md_adc_set_normal_channel_conv_start_nchtrg(ADC0);

    while (1)
    {
    }
}

/**
  * @}
  */
/**
  * @}
*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
