/**********************************************************************************
 *
 * @file    main.c
 * @brief   ADC0_ExternalTrigger C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include <string.h>
#include "main.h"
void SystemInit()
{}
/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/* Public Variables ---------------------------------------------------------- */
md_adc_init_t g_adc_init;
md_pis_init_t g_p_init;

/** @addtogroup Public_Function
  * @{
  */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Configure the ADC0 Pins.
  * @param  None
  * @retval None
  */
void gpio_pin_config()
{
    md_gpio_init_t x;
    md_gpio_init_struct(&x);

    /* Initialize adc gpio pin */
    x.mode  = MD_GPIO_MODE_CLOSE;
    x.pupd  = MD_GPIO_FLOATING;
    x.odos  = MD_GPIO_PUSH_PULL;
    x.odrv  = MD_GPIO_OUT_DRIVE_NORMAL;
    x.flt   = MD_GPIO_FILTER_DISABLE;
    x.type  = MD_GPIO_TYPE_CMOS;
    x.func  = MD_GPIO_FUNC_0;

    md_gpio_init(ADC_CHANNEL7_GPIO_PORT, ADC_CHANNEL7_PIN, &x);

    return;
}

/**
  * @brief  Configure the TIM Pins.
  * @param  None
  * @retval None
  */
void adc_base_config()
{
    md_adc_struct_init(&g_adc_init);
    /* Set ADC0 Base Configuration:  */
    g_adc_init.align    = MD_ADC_DATAALIGN_RIGHT;     /* Specifies ADC0 data alignment */
    g_adc_init.data_bit = MD_ADC_CONV_BIT_12;
    g_adc_init.div      = MD_ADC_CKDIV_16;            /* ADC0CLK divider */
    g_adc_init.n_ref    = MD_ADC_NEG_REF_VSS;
    g_adc_init.p_ref    = MD_ADC_POS_REF_VDD;         /* The positive reference voltage */
    md_adc_init(ADC0, &g_adc_init);

    /* Disable ADC0 sequencers scan mode*/
    md_adc_disable_scanen(ADC0);
    /* Set ADC0 continuous conversion mode on ADC0 group REG */
    md_adc_continuous_conversion_disable_cm(ADC0);

    /* Set ADC0 group insert sequencer length and scan direction,ADC0 conversion 1 channel */
    md_adc_set_insert_channel_length_isl(ADC0, MD_ADC_ICH_NR_1);
    /* Set ADC0 group insert sequence: channel on the selected scan sequence rank */
    md_adc_set_insert_1st_conv_is1(ADC0, MD_ADC_CHANNEL_7);
    md_adc_set_smpt1_cht(ADC0, MD_ADC_SAMPLETIME_2, MD_ADC_CHANNEL_7);

    /* ADC0 insert trig polarity */
    md_adc_set_insert_conv_extern_polarity(ADC0, MD_ADC_ETS_RISE);

    /* Set priority for ADC0_IRQn */
    NVIC_SetPriority(ADC0_IRQn, 0);
    /* Enable ADC0_IRQn */
    NVIC_EnableIRQ(ADC0_IRQn);
    /* Enable interruption ADC0 group insert end of sequence conversions */
    md_adc_inserted_channel_interrupt_enable_icheie(ADC0);
}

/**
  * @brief  Initialize TIMER.
  * @param  None
  * @retval None
  */
void timer_init(void)
{
    md_timer_base_init_t init;
    md_timer_base_struct_init(&init);
    init.prescaler = 4800 - 1;
    init.period = 10000;
    md_timer_base_set_config(AD16C4T, &init);
}

/**
  * @brief  Initialize PIS.
  * @param  None
  * @retval None
  */
void pis_init(void)
{
    /* Initialize PIS */
    memset(&g_p_init, 0, sizeof(md_pis_init_t));

    g_p_init.p_src     = MD_PIS_AD16C4T_UPDATE;
    g_p_init.c_trig    = MD_PIS_CH5_ADC_INSERT;

    md_pis_init(&g_p_init);
}

/**
  * @brief  Test main function
  * @retval Status.
  */
uint32_t g_adc_result;
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Enable the selected ADC0 instance */
    md_adc_converter_enable_adcen(ADC0);
    /* Disable the selected ADC0 instance */
    md_adc_converter_disable_adcen(ADC0);

    /* Initialize PIS */
    pis_init();

    /* Initialize TIMER */
    timer_init();

    /* Pin Configuration */
    gpio_pin_config();

    /* ADC0 Base Feature Configuration */
    adc_base_config();

    /*Enable the selected ADC0 instance */
    md_adc_converter_enable_adcen(ADC0);

    /* Start TIMER */
    md_timer_enable_counter_cnten(AD16C4T);

    while (1)
    {
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
