/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{
    return;
}

/**
  * @brief  Initialize TOGGLE IO and AD16C4T1 TE IO
  * @param  None
  * @retval None
  */
static void init_gpio(void)
{
    md_gpio_init_t gpio_init;

    /* Initialize TOGGLE IO as output */
    md_gpio_init_struct(&gpio_init);     /* initialize the gpio_init */
    gpio_init.func = MD_GPIO_FUNC_1;     /* GPIO function 1 */
    gpio_init.mode = MD_GPIO_MODE_OUTPUT;/* output */
    gpio_init.odos = MD_GPIO_PUSH_PULL;  /* push pull */
    gpio_init.pupd = MD_GPIO_FLOATING;   /* no pull up and pull donw */
    md_gpio_init(TOGGLE_PORT, TOGGLE_PIN, &gpio_init);

    /* Initialize ET */
    md_gpio_init_struct(&gpio_init);            /* initialize the gpio_init */
    gpio_init.func = MD_GPIO_FUNC_7;            /* GPIO function 4 */
    gpio_init.mode = MD_GPIO_MODE_INPUT;        /* input */
    gpio_init.pupd = MD_GPIO_FLOATING;          /* no pull up and pull donw */
    gpio_init.flt = MD_GPIO_FILTER_DISABLE;     /* no filter */
    gpio_init.type = MD_GPIO_TYPE_CMOS;         /* TTL */
    md_gpio_init(ET_PORT, ET_PIN, &gpio_init);

    return;
}

/**
  * @brief:  Initialize AD16C4T to timely overflow funtion
  * @param:  None
  * @retval: None
  */
static void init_timer(void)
{
    md_timer_base_init_t ad16c4t_init;

    md_timer_base_struct_init(&ad16c4t_init);   /* initialize the ad16c4t_init  */
    ad16c4t_init.prescaler = 1 - 1;             /* clk_count */
    ad16c4t_init.clk_div = MD_TIMER_CLOCK_DIV1; /* working clock of dead time and filter */
    ad16c4t_init.mode = MD_TIMER_CNT_MODE_UP;   /* count up */
    ad16c4t_init.period = 100 - 1;              /* period is 100 count clock */
    ad16c4t_init.re_cnt = 1 - 1;                /* no repeat count */
    md_timer_base_set_config(AD16C4T, &ad16c4t_init);

    md_timer_enable_external_clk2mode_ecm2en(AD16C4T);          /* enable external clock2 mode */
    md_timer_set_external_trigger_prescaler_etpsel(AD16C4T, 0); /* 0x0: Prescaler OFF */
    md_timer_set_external_trigger_polarity_etpol(AD16C4T, 0);   /* 0x0: active at rising edge. */
    md_timer_set_external_trigger_filter_etflt(AD16C4T, 0);     /* 0x0:No filter */

    md_timer_enable_uit_interrupt(AD16C4T);  /* enable NVIC AD16C4T1 updata interrupt */
    md_timer_enable_counter_cnten(AD16C4T);  /* enable AD16C4T1 */

    /* Set priority for ADTIM0_BRK_UP_TRIGCOM_IRQn */
    NVIC_SetPriority(ADTIM0_BRK_UP_TRIGCOM_IRQn, 0);
    /* Enable ADTIM0_BRK_UP_TRIGCOM_IRQn */
    NVIC_EnableIRQ(ADTIM0_BRK_UP_TRIGCOM_IRQn);

    return;
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt  */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    init_gpio();
    init_timer();

    while (1);
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
