/**********************************************************************************
 *
 * @file    main.c
 * @brief   main C file
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Function ---------------------------------------------------------- */
/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/** @addtogroup Projects_Examples_MD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  Initializate system.
  * @retval None
  */
void SystemInit(void)
{
    return;
}

/**
  * @brief  Initializate pin of usart module.
  * @retval None
  */
static void gpio_init(void)
{
    md_gpio_init_t gpio_init;
    memset(&gpio_init, 0, sizeof(md_gpio_init_t));

    gpio_init.mode = MD_GPIO_MODE_INPUT;
    gpio_init.func = MD_GPIO_FUNC_0;
    gpio_init.type = MD_GPIO_TYPE_CMOS;
    md_gpio_init(ACMP0_IN_PORT, ACMP0_IN1_PIN, &gpio_init);

    /* Initialize TOGGLE IO as output */
    gpio_init.func = MD_GPIO_FUNC_4;      /* PIS_CH5 */
    gpio_init.mode = MD_GPIO_MODE_OUTPUT; /* output */
    md_gpio_init(TOGGLE_PORT, TOGGLE_PIN, &gpio_init);

    return;
}

/**
  * @brief  Initialize PIS.
  * @param  None
  * @retval None
  */

void pis_init(void)
{
    md_pis_init_t g_p_init;

    /* Initialize PIS */
    memset(&g_p_init, 0, sizeof(md_pis_init_t));

    g_p_init.p_src  = MD_PIS_ACMP_OUT0;
    g_p_init.c_trig = 5;
    PIS->CH_OER = 1 << 5;
    md_pis_init(&g_p_init);
}

/**
  * @brief:  Main program.
  * @param:  None
  * @retval: None
  */
int main()
{
    /* Configure system clock */
    md_cmu_clock_config(MD_CMU_CLOCK_HRC, 32000000);
    /* Initialize SysTick Interrupt */
    md_init_1ms_tick();

    /* Enable ALL peripheral */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* Enable ACMP0 interrupt */
    md_mcu_irq_config(ACMP0_IRQn, 1, ENABLE);

    pis_init();

    /* Initialize pin */
    gpio_init();

    /* Enable ADC VREF */
    MODIFY_REG(ADC0->CCR, ADC_CCR_VREFEN_MSK, ENABLE << ADC_CCR_VREFEN_POS);

    /* acmp init */
    md_acmp_init_t acmp;
    acmp.flt             = MD_ACMP_0_FLT_PCLK;
    acmp.mode            = MD_ACMP_HIGH_POWER;
    acmp.warm_time       = MD_ACMP_64_PCLK;
    acmp.hystsel         = MD_ACMP_HYST_22;
    acmp.p_port          = MD_ACMP_POS_CH1;
    acmp.n_port          = MD_ACMP_NEG_1V;
    acmp.inactval        = MD_ACMP_INACTVAL_LOW;
    acmp.out_inv         = DISABLE;
    acmp.edge            = MD_ACMP_EDGE_ALL;
    md_acmp_init(ACMP0, &acmp);
    md_acmp_enable_output_port(ACMP0);

    md_acmp_interrupt_config(ACMP0, MD_ACMP_IT_EDGE, ENABLE);

    while (1)
    {
        md_delay_1ms(10);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
