/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
uint8_t g_rx_buf[64];
uint16_t g_rx_len = sizeof(g_rx_buf);
uint16_t g_rx_i = 0U;
uint8_t g_flag = 0U;

uint16_t g_frame_timer;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler, already defined in startup file
  * @retval None
  */

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();

    /* the time interval of received adjacent bytes in the same frame is more than expected, reset rx FIFO */
    if (g_frame_timer != 0)
    {
        g_frame_timer--;

        if (g_frame_timer == 0)
            g_rx_i = 0;
    }

    return;
}

/**
  * @brief:  This function handles UART0 exception.
  * @param:  None
  * @retval: None
  */
void USART0_Handler(void)
{
    if (md_usart_is_enabled_it_rxne(USART0) && md_usart_is_active_flag_rxne(USART0))
    {
        md_usart_clear_flag_rxne(USART0);

        /* strongly recommend to enable idle irq in rxne interrupt service function */
        md_usart_enable_it_idle(USART0);

        g_rx_buf[g_rx_i++] = md_usart_recv_data8(USART0);

        /* assign timer to default when MCU receive each byte */
        g_frame_timer = FRAME_INTERVAL;

        if(g_rx_buf[0] != 0x3F)
            g_rx_i = 0;

        if (g_rx_i >= 8)
        {
            g_rx_i = 0;
            g_flag = 1;
        }

        if (g_rx_i >= g_rx_len)
            g_rx_i = 0;
    }

    if (md_usart_is_enabled_it_idle(USART0) && md_usart_is_active_flag_idle(USART0))
        md_usart_clear_flag_idle(USART0);
}

/**
  * @}
  */

/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
