/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    27 Oct 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          27 Oct 2021     Biyq            the first version
 *          22 Feb  2023    shicc           version:1.0.1
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"
#include "exec_proc.h"
#include "comm_proc.h"
#include "micro_boot.h"

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

/* Exported Variables -------------------------------------------------------- */

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#define __USE_CRC32
#define SPI_PORT    GPIOA
#define SPI_NSS_PIN  MD_GPIO_PIN_0
#define SPI_SCK_PIN  MD_GPIO_PIN_10
#define SPI_MOSI_PIN MD_GPIO_PIN_11
#define SPI_MISO_PIN MD_GPIO_PIN_12

#define APP_ADDR    0x2000
#define BOOT_ADDR   0x0000
#define GO_APP      0xFFFFFFFE
#define GO_BOOT     0xFFFFFFFD

#ifdef  __USE_CRC32
    #define CRC_CAL_ADDR    0x00007E00
#endif

#endif  /* */

