/**********************************************************************************
 *
 * @file    exec_proc.h
 * @brief   Header file for exec_proc.c
 *
 * @date    27 Oct 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          27 Oct 2021     Biyq            the first version
 *          22 Feb  2023    shicc           version:1.0.1
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __COMM_PROC_H__
#define __COMM_PROC_H__


/* Includes ---------------------------------------------------------------- */

#include <stdint.h>
#include <string.h>
#include "md_conf.h"
#include "micro_boot.h"


/* Exported Macros ----------------------------------------------------------- */

#define COMMUNICATION_TYPE SPI0

/* Exported Variables -------------------------------------------------------- */


/* Exported Constants -------------------------------------------------------- */


/* Exported Types ---------------------------------------------------------- */


/* Exported Functions ------------------------------------------------------ */

/**
  * @brief  assign functions related to communication to the state machine subfunction pointer,
            it must be called before using void fsm_para_init(void).
  * @param  None
  * @retval None
  */
void fsm_comm_func_init(void);

/**
  * @brief  function to handle communication interrupt.
  * @param  None
  * @retval None
  */
void fsm_int_exec(void);

/**
  * @brief  function to handle systick interrupt.
  * @param  None
  * @retval None
  */
void fsm_systick_int_exec(void);


#endif   /* */
