/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    28 Oct 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          28 Oct 2021     Biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */
uint8_t g_rx_buf[64];
uint8_t g_tx_buf = NEG_ACK;
uint16_t g_rx_len = sizeof(g_rx_buf);
uint16_t g_rx_i = 0U;
uint8_t g_flag = 0U;

uint16_t g_frame_timer;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/** @addtogroup Projects_Examples_ALD
  * @{
  */

/** @addtogroup Examples
  * @{
  */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler, already defined in startup file
  * @retval None
  */

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();

    /* the time interval of received adjacent bytes in the same frame is more than expected, reset rx FIFO */
    if (g_frame_timer != 0)
    {
        g_frame_timer--;

        if (g_frame_timer == 0)
            g_rx_i = 0;
    }

    return;
}

/**
  * @brief  I2C Event IRQ handler
  * @retval None
  */
void I2C0_Handler(void)
{
    /*Send buffer empty*/
    if ((md_i2c_is_active_flag_txbe(I2C0)) && md_i2c_is_enable_it_buf(I2C0) && md_i2c_is_enable_it_evt(I2C0))
    {
        md_i2c_transmit_data8(I2C0, g_tx_buf);

        if (g_tx_buf == POS_ACK)
            g_flag = 1;
        else
            g_flag = 0;
    }

    /*Receive buffer is not empty*/
    if ((md_i2c_is_active_flag_rxne(I2C0)) && md_i2c_is_enable_it_buf(I2C0) && md_i2c_is_enable_it_evt(I2C0))
    {
        g_rx_buf[g_rx_i++] = md_i2c_receive_data8(I2C0);

        /* assign timer to default when MCU receive each byte */
        g_frame_timer = FRAME_INTERVAL;

        if (g_rx_buf[0] != 0x3F)
            g_rx_i = 0;

        if (g_rx_i >= 8)
        {
            g_rx_i = 0;

            if (g_rx_buf[1] == 0xA1 && g_rx_buf[2] == 0x5E && g_rx_buf[3] == 0xFF
                    && g_rx_buf[4] == 0xFF && g_rx_buf[5] == 0xFF && g_rx_buf[6] == 0xFD
                    && g_rx_buf[7] == 0xFA)
                g_tx_buf = POS_ACK;
            else
                g_tx_buf = NEG_ACK;
        }

        if (g_rx_i >= g_rx_len)
            g_rx_i = 0;
    }

    /*From the machine address matching*/
    if (md_i2c_is_active_flag_addr(I2C0) && md_i2c_is_enable_it_evt(I2C0))
    {
        md_i2c_clear_flag_addr(I2C0);
        md_i2c_enable_it_buf(I2C0);
    }

    /*Failed to reply*/
    if (md_i2c_is_active_flag_af(I2C0) && md_i2c_is_enable_it_err(I2C0))
    {
        md_i2c_clear_flag_af(I2C0);     /*Clear reply marks a failure*/
        md_i2c_disable_it_buf(I2C0);
        g_rx_i = 0;
    }

    /*The bus stop bit is detected*/
    if (md_i2c_is_active_flag_stop(I2C0) && md_i2c_is_enable_it_evt(I2C0))
    {
        md_i2c_clear_flag_stop(I2C0);       /*To generate the stop bit*/
        md_i2c_disable_it_buf(I2C0);
        g_rx_i = 0;
    }

    /*SMBALARM*/
    if (md_i2c_is_active_smbus_flag_alert(I2C0) && md_i2c_is_enable_it_err(I2C0))
        md_i2c_clear_smbus_flag_alert(I2C0);

    /*SMBTO*/
    if (md_i2c_is_active_smbus_flag_timeout(I2C0) && md_i2c_is_enable_it_err(I2C0))
        md_i2c_clear_smbus_flag_timeout(I2C0);

    /*PECERR*/
    if (md_i2c_is_active_smbus_flag_pecerr(I2C0) && md_i2c_is_enable_it_err(I2C0))
        md_i2c_clear_smbus_flag_pecerr(I2C0);

    /*ROUERR*/
    if (md_i2c_is_active_flag_ovr(I2C0) && md_i2c_is_enable_it_err(I2C0))
        md_i2c_clear_flag_ovr(I2C0);

    /*LARB*/
    if (md_i2c_is_active_flag_arlo(I2C0) && md_i2c_is_enable_it_err(I2C0))
        md_i2c_clear_flag_arlo(I2C0);

    /*BUSERR*/
    if (md_i2c_is_active_flag_berr(I2C0) && md_i2c_is_enable_it_err(I2C0))
        md_i2c_clear_flag_berr(I2C0);

    return;
}

/**
  * @}
  */
/**
  * @}
  */
