/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    28 Oct 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          28 Oct 2021     Biyq            the first version
 *          15 Mar  2023    shicc           version:1.0.1

 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
__STATIC_INLINE void md_i2c_clear_flag_addr(I2C_TypeDef *i2c)
{
    __IO uint32_t tmpreg;
    tmpreg = i2c->STAT1;
    (void) tmpreg;
    tmpreg = i2c->STAT2;
    (void) tmpreg;
}

__STATIC_INLINE void md_i2c_clear_flag_stop(I2C_TypeDef *i2c)
{
    __IO uint32_t tmpreg;
    tmpreg = i2c->STAT1;
    (void) tmpreg;

    SET_BIT(i2c->CON1, I2C_CON1_PEN_MSK);
}
__STATIC_INLINE void md_i2c_clear_smbus_flag_alert(I2C_TypeDef *i2c)
{
    CLEAR_BIT(i2c->STAT1, I2C_STAT1_SMBALARM_MSK);
}

/* Exported Variables -------------------------------------------------------- */
extern uint8_t g_flag;

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#define LED_PORT GPIOA
#define LED_PIN MD_GPIO_PIN_15

#define SLAVE_ADDR 0x2D
#define APP_ADDR    0x2000
#define BOOT_ADDR   0x0000
#define CRC_CAL_PAGE_ADDR   0x00007E00
#define GO_APP      0xFFFFFFFE
#define GO_BOOT     0xFFFFFFFD

#define POS_ACK 0x79
#define NEG_ACK 0x1F

#define FRAME_INTERVAL   500    /* the longest time interval between received cmd frame and execution result frame */

#endif  /* __MAIN_H__ */

