/**********************************************************************************
 *
 * @file    mac_statics.h
 * @brief   MAC/CSMA statics data
 *
 * @date    7  Nov  2022
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          7  Nov  2022    shiwa           MAC/CSMA statics data
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef MAC_STATICS_H
#define MAC_STATICS_H

#define CSMA_STATICS

#ifdef CSMA_STATICS
enum {
    CSMA_STAT_INPUT,
    CSMA_STAT_ACK_IGNORED,
    CSMA_STAT_PARSE_FAILED,
    CSMA_STAT_NOT_FOR_US,
    CSMA_STAT_FROM_SELF,
    CSMA_STAT_DUPLICATE,
    
    CSMA_STAT_OUTPUT,
    CSMA_STAT_TXOK,
    CSMA_STAT_COLLISION,
    CSMA_STAT_NOACK,
    CSMA_STAT_TXERR,
    
    CSMA_STAT_NUM
};

#define INC_CSMA_STAT(x) csma_statics[x]++
#else
#define INC_CSMA_STAT(x)
#endif

extern int csma_statics[16];
#endif
