/**********************************************************************************
 *
 * @file    cmd_utils.h
 * @brief   Command utils
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          7  Nov  2022    shiwa           Command and checksum utils
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
#include <stdint.h>
#include <stdbool.h>

enum {
    CMD_OK,
    CMD_LEN_TOO_SHORT,
    CMD_ERROR_FORMAT,
    CMD_ERROR_CHECKSUM,
    CMD_UNKNOWN,
    CMD_INVALID_PARAM,
    CMD_LEN_TOO_LONG,
    CMD_RESULTS_NUM
};

extern int strcmp_prefix(char *s, const char *p, char **last);
extern int strcpy_prefix(char *s, const char *p);
extern bool check_sum(uint8_t *s, uint32_t len);
extern int process_cmd(char *s, uint32_t len, char type);
extern uint8_t calc_chksum(uint8_t*data,uint32_t len);
extern const char*get_cmd_error_str(int errcode);

#define USE_CHECK_SUM 1
#ifdef USE_CHECK_SUM
#define CHECKSUM_LEN 1  //CHECKSUM 8bit
#else
#define CHECKSUM_LEN 0
#endif
