#include <stdio.h>
#include <string.h>
#include "contiki.h"
#include "contiki-net.h"
#include "sys/autostart.h"
#include "autostart.h"

#include "dev/leds.h"
#include "dev/slip.h"
#include "dev/watchdog.h"
#include "lib/random.h"
#include "net/netstack.h"
#include "net/ip/uip.h"
#include "net/mac/frame802154.h"

#include "radio-driver.h"
#include "radio-arch.h"

#include "node-id.h"
#include "stdbool.h"
#include "dev/button-sensor.h"
#include "dev/radio-sensor.h"
#include "contiki-st-radio-main.h"

#include "low-power.h"

#ifdef WITH_IP64
#include "ip64.h"
#include "ip64-addr.h"
#endif

#ifdef USE_STM32L1XX_NUCLEO
#include "stm32l1xx.h"
#endif

#ifdef USE_STM32F4XX_NUCLEO
#include "stm32f4xx.h"
#endif
/*---------------------------------------------------------------------------*/
#if NETSTACK_CONF_WITH_IPV6
#include "net/ipv6/uip-ds6.h"
#endif /*NETSTACK_CONF_WITH_IPV6*/

/*---------------------------------------------------------------------------*/
void contiki_init()
{
  /* Initialize Contiki and our processes. */
  clock_init();
  ctimer_init();
  rtimer_init();
  watchdog_init();
  
  process_init();
  process_start(&etimer_process, NULL);
  
  /* Restore node id if such has been stored in external mem */
  node_id_restore(); /* also configures node_mac[] */
  
  random_init(node_id);
  
  set_rime_addr();
  
  netstack_init();
  
  //subGHz_radio_driver.on();
  
  //energest_init();
  
  
#if NETSTACK_CONF_WITH_IPV6
  memcpy(&uip_lladdr.addr, node_mac, sizeof(uip_lladdr.addr));
  
  queuebuf_init();
  process_start(&tcpip_process, NULL);
  
  uip_ipaddr_t ipaddr;
  uip_ip6addr(&ipaddr, 0xfe80, 0, 0, 0, 0, 0, 0, 0);
  uip_ds6_set_addr_iid(&ipaddr, &uip_lladdr);
  uip_ds6_addr_add(&ipaddr, 0, ADDR_AUTOCONF);  
#endif /* NETSTACK_CONF_WITH_IPV6*/
  
  print_parameters();
  
  PRINTF("Contiki and Sub-GHz Radio correctly configured... Starting all processes\n");
  
#ifndef SERIAL_SNIFFER  
  process_start(&sensors_process, NULL);
#endif /*SERIAL_SNIFFER*/
  autostart_start(autostart_processes);
  
#if WITH_IP64
  uip_ip4addr_t ipv4addr, netmask, ip4addr;
  uip_ip6addr_t ip6addr;
  
  uip_ipaddr(&ipv4addr, 192, 168, 0, 1);
  uip_ipaddr(&netmask, 255, 255, 255, 0);
  ip64_set_ipv4_address(&ipv4addr, &netmask);
  /*  printf("IPv4 address %d.%d.%d.%d\n",
  ipv4addr.u8[0], ipv4addr.u8[1],
  ipv4addr.u8[2], ipv4addr.u8[3]);
  */
  uip_ipaddr(&ip4addr, 8,8,8,8);
  ip64_addr_4to6(&ip4addr, &ip6addr);
  uip_nameserver_update((uip_ipaddr_t *)&ip6addr, UIP_NAMESERVER_INFINITE_LIFETIME);
#endif /*WITH_IP64*/
  
  watchdog_start();
  
}