/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#ifndef BOARD_3696LT
#define UART_X UART2
#define UART_TX_PORT GPIOE
#define UART_TX_PIN  GPIO_PIN_2
#define UART_RX_PORT GPIOE
#define UART_RX_PIN  GPIO_PIN_3
#define UART_X_IRQ_Handler UART2_Handler

#define LED_0_PORT GPIOC
#define LED_0_PIN GPIO_PIN_8 
#define LED_1_PORT GPIOC
#define LED_1_PIN GPIO_PIN_12
#define LED_2_PORT GPIOC
#define LED_2_PIN GPIO_PIN_7
#define LED_3_PORT GPIOC
#define LED_3_PIN GPIO_PIN_6
#else
#define UART_X UART0
#define UART_TX_PORT GPIOB
#define UART_TX_PIN  GPIO_PIN_10
#define UART_RX_PORT GPIOB
#define UART_RX_PIN  GPIO_PIN_11
#define UART_X_IRQ_Handler UART0_Handler

#define LED_0_PORT GPIOF
#define LED_0_PIN GPIO_PIN_0 
#define LED_1_PORT GPIOF
#define LED_1_PIN GPIO_PIN_1
#define LED_2_PORT GPIOF
#define LED_2_PIN GPIO_PIN_0
#define LED_3_PORT GPIOF
#define LED_3_PIN GPIO_PIN_1

#endif
/* Exported Variables -------------------------------------------------------- */

extern uart_handle_t g_uart_init;

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

#endif    /*__MAIN_H__*/


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
