#ifndef CONTIKI_CONF_H
#define CONTIKI_CONF_H

#include <inttypes.h>
#include <ctype.h>

typedef unsigned int uip_stats_t;

#ifndef UIP_CONF_BYTE_ORDER
#define UIP_CONF_BYTE_ORDER      UIP_LITTLE_ENDIAN
#endif

//#define ROUTING_CONF_NULLROUTING 1
#define ROUTING_CONF_RPL_LITE 1  
#define NETSTACK_CONF_WITH_IPV6 1 
#define MAC_CONF_WITH_CSMA 1
extern const struct radio_driver subGHz_radio_driver;
//#define NETSTACK_CONF_RADIO nullradio_driver
#define NETSTACK_CONF_RADIO subGHz_radio_driver
#define NETSTACK_CONF_FRAMER framer_802154

/* configure network size and density */
#ifndef NETSTACK_MAX_ROUTE_ENTRIES
#define NETSTACK_MAX_ROUTE_ENTRIES   8
#endif /* NETSTACK_MAX_ROUTE_ENTRIES */
#ifndef NBR_TABLE_CONF_MAX_NEIGHBORS
#define NBR_TABLE_CONF_MAX_NEIGHBORS 8
#endif /* NBR_TABLE_CONF_MAX_NEIGHBORS */

/* configure queues */
#ifndef QUEUEBUF_CONF_NUM
#define QUEUEBUF_CONF_NUM 4
#endif /* QUEUEBUF_CONF_NUM */

#define UIP_CONF_BUFFER_SIZE 512
#define UIP_CONF_UDP_CONNS 2
#define IEEE802154_CONF_PANID 0xabcd

//#define RPL_CONF_DEFAULT_LEAF_ONLY 1

typedef unsigned long clock_time_t;

#define CLOCK_CONF_SECOND 1000

#define LOG_CONF_ENABLED 1

#define PLATFORM_CONF_MAIN_ACCEPTS_ARGS  0
#define PLATFORM_CONF_SUPPORTS_STACK_CHECK 0
#define CSMA_CONF_SEND_SOFT_ACK 1

#define UIP_CONF_STATISTICS 1

#define CONTIKI_VERSION_STRING "contiki-ng-es32"
#define CONTIKI_TARGET_STRING "es32f3696"

extern int log_output(const char*fmt,...);
#define LOG_CONF_OUTPUT(...) log_output(__VA_ARGS__)
#define ENABLE_DEBUG_LOG 1
#if ENABLE_DEBUG_LOG 
#define LOG_CONF_LEVEL_RPL LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_MAC LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_TCPIP LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_IPV6 LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_6LOWPAN LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_NULLNET LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_FRAMER LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_6TOP LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_COAP LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_SNMP LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_LWM2M LOG_LEVEL_ERR
#define LOG_CONF_LEVEL_MAIN LOG_LEVEL_INFO
#endif
#define NETSTACK_CONF_WITH_IPV6 1
#endif
