import os
import sys
# toolchains options
ARCH='arm'
CPU='cortex-m3'
CROSS_TOOL='keil'

# cross_tool provides the cross compiler
# EXEC_PATH is the compiler execute path, for example, CodeSourcery, Keil MDK, IAR

if  CROSS_TOOL == 'gcc':
	PLATFORM 	= 'gcc'
	EXEC_PATH 	= 'C:/SourceryGCC/bin'
elif CROSS_TOOL == 'keil':
	PLATFORM 	= 'armcc'
	EXEC_PATH 	= 'C:/Keil_v5'
elif CROSS_TOOL == 'iar':
	PLATFORM 	= 'iar'
	EXEC_PATH 	= 'C:/Program Files (x86)/IAR Systems/Embedded Workbench 8.0'

if os.getenv('RTT_EXEC_PATH'):
	EXEC_PATH = os.getenv('RTT_EXEC_PATH')

BUILD = 'debug'

if PLATFORM == 'gcc':
    print "PLATFORM == 'gcc'"
    # toolchains
    PREFIX = 'arm-none-eabi-'
    CC = PREFIX + 'gcc'
    AS = PREFIX + 'gcc'
    AR = PREFIX + 'ar'
    LINK = PREFIX + 'gcc'
    TARGET_EXT = 'elf'
    SIZE = PREFIX + 'size'
    OBJDUMP = PREFIX + 'objdump'
    OBJCPY = PREFIX + 'objcopy'

    DEVICE = ' -mcpu=cortex-m3 -mthumb -ffunction-sections -fdata-sections'
    CFLAGS = DEVICE
    AFLAGS = ' -c' + DEVICE + ' -x assembler-with-cpp'
    LFLAGS = DEVICE + ' -Wl,--gc-sections,-Map=es32f369x.map,-cref,-u'

    CPATH = ''
    LPATH = ''

    if BUILD == 'debug':
        CFLAGS += ' -O0 -gdwarf-2'
        AFLAGS += ' -gdwarf-2'
    else:
        CFLAGS += ' -O2'

    POST_ACTION = OBJCPY + ' -O binary $TARGET es32f369x.bin\n' + SIZE + ' $TARGET \n'

elif PLATFORM == 'armcc':
    print "PLATFORM == 'armcc'"
    # toolchains
    '''
    KEIL_PATH='C:/Keil_v5'
    sys.path+=[os.path.normpath(KEIL_PATH+'/ARM/ARMCC/bin')]
    CC = os.path.normpath(KEIL_PATH+'/ARM/ARMCC/bin/armcc.exe')
    AS = os.path.normpath(KEIL_PATH+'/ARM/ARMCC/bin/armasm.exe')
    AR = os.path.normpath(KEIL_PATH+'/ARM/ARMCC/bin/armar.exe')
    LINK = os.path.normpath(KEIL_PATH+'/ARM/ARMCC/bin/armlink.exe')
    FROMELF = os.path.normpath(KEIL_PATH+'/ARM/ARMCC/bin/fromelf.exe')
    '''
    CC = 'armcc.exe'
    AS = 'armasm.exe'
    AR = 'armar.exe'
    LINK = 'armlink.exe'
    FROMELF = 'fromelf.exe'
    TARGET_EXT = 'axf'

    DEVICE = ' --cpu ' + CPU
    CFLAGS = '-c ' + DEVICE + ' --apcs=interwork --c99 --split_sections'
    AFLAGS = DEVICE + ' --apcs=interwork '
    LFLAGS = DEVICE + ' --info sizes --info totals --info unused --info veneers --list es32f369x.map --scatter es32f36xx.sct'

    CFLAGS += ' --c99'
    CFLAGS += ' -I' + EXEC_PATH + '/ARM/ARMCC/include'
    LFLAGS += ' --libpath ' + EXEC_PATH + '/ARM/ARMCC/lib' 
    #LFLAGS += '/tools'

    EXEC_PATH += '/ARM/ARMCC/bin'

    if BUILD == 'debug':
        CFLAGS += ' -g -O0'
        AFLAGS += ' -g'
    else:
        CFLAGS += ' -O2'

    POST_ACTION1 = 'fromelf --bin $TARGET --output es32f369x.bin \nfromelf -z $TARGET'
    POST_ACTION = POST_ACTION1 + 'fromelf --i32 $TARGET --output es32f369x.hex \nfromelf -z $TARGET'

elif PLATFORM == 'iar':
    print "PLATFORM == 'iar'"
    # toolchains
    CC = 'iccarm'
    AS = 'iasmarm'
    AR = 'iarchive'
    LINK = 'ilinkarm'
    TARGET_EXT = 'out'

    DEVICE = '-Dewarm' # + ' -D' + PART_TYPE

    CFLAGS = DEVICE
    CFLAGS += ' --diag_suppress Pa050'
    CFLAGS += ' --no_cse' 
    CFLAGS += ' --no_unroll' 
    CFLAGS += ' --no_inline' 
    CFLAGS += ' --no_code_motion' 
    CFLAGS += ' --no_tbaa' 
    CFLAGS += ' --no_clustering' 
    CFLAGS += ' --no_scheduling' 

    CFLAGS += ' --endian=little' 
    CFLAGS += ' --cpu=Cortex-M3' 
    CFLAGS += ' -e' 
    CFLAGS += ' --dlib_config "' + EXEC_PATH + '/arm/INC/c/DLib_Config_Full.h"'
    CFLAGS += ' --silent'
        
    AFLAGS = DEVICE
    AFLAGS += ' -s+' 
    AFLAGS += ' -w+' 
    AFLAGS += ' -r' 
    AFLAGS += ' --cpu Cortex-M3' 
    AFLAGS += ' -S'

    if BUILD == 'debug':
        CFLAGS += ' --debug'
        CFLAGS += ' -On'
    else:
        CFLAGS += ' -Oh'

    LFLAGS = ' --config "' + EXEC_PATH + '/arm/config/linker/Eastsoft/es32f369x.icf"'
    LFLAGS += ' --entry __iar_program_start'
    #LFLAGS += ' --silent'

    EXEC_PATH = EXEC_PATH + '/arm/bin/'
    POST_ACTION = ''

#according ald_conf.h or md_conf.h include the source with same name
import re

define = []
ald_lib_src = []
md_lib_src = []

def include_lib_source(fp, source=[]):
    #preprocessor, delete comment
    comment_pattern = re.compile(r"//[^\r\n]*|/\*.*?\*/", re.S)
    preprocessor = re.sub(comment_pattern, "", fp.read())
    #find the define
    define_pattern = re.compile(r'.*?#define\s+(\S+)')
    define = define_pattern.findall(preprocessor)
    #find #ifdef #include "xx.h" #endif
    ifdef_pattern = re.compile(\
        r'.*?#ifdef\s+(\S+)\s+?#include\s+"(\S+).h".*?#endif', re.S)
    ifdef_include = ifdef_pattern.findall(preprocessor)
    #convert to c source file
    for i in define:
        for num in range(len(ifdef_include)):
            if ifdef_include[num][0] == i:
                source.append(ifdef_include[num][1] + '.c')
    fp.close()

if os.path.isfile('Inc/ald_conf.h'):
    fp = open("Inc/ald_conf.h", 'r')
    include_lib_source(fp, ald_lib_src)

if os.path.isfile('Inc/md_conf.h'):
    fp = open("Inc/md_conf.h", 'r')
    include_lib_source(fp, md_lib_src)
