/**
  *********************************************************************************
  *
  * @file    drv_uart.h
  * @brief   UART driver for rt-thread-nano console.
  *
  * @version V1.0
  * @date    01 Sep 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          01 Sep 2022     AE Team         The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *********************************************************************************
  */
#ifndef DRV_UART_H
#define DRV_UART_H

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
//#define CONSOLE_USE_UART
#define CONSOLE_USE_LPUART

#ifdef CONSOLE_USE_UART
#define CONSOLE_UART UART0
#define CONSOLE_UART_TX_PORT GPIOB
#define CONSOLE_UART_TX_PIN  GPIO_PIN_6 
#define CONSOLE_UART_TX_FUNC GPIO_FUNC_2
#define CONSOLE_UART_RX_PORT GPIOB
#define CONSOLE_UART_RX_PIN  GPIO_PIN_7 
#define CONSOLE_UART_RX_FUNC GPIO_FUNC_2
#endif
#ifdef CONSOLE_USE_LPUART
#define CONSOLE_UART LPUART0
#define CONSOLE_UART_TX_PORT GPIOB
#define CONSOLE_UART_TX_PIN  GPIO_PIN_10 
#define CONSOLE_UART_TX_FUNC GPIO_FUNC_4
#define CONSOLE_UART_RX_PORT GPIOB
#define CONSOLE_UART_RX_PIN  GPIO_PIN_11 
#define CONSOLE_UART_RX_FUNC GPIO_FUNC_4

#endif
/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
void uart_send_str(const char*s);

#endif
