#include <stdio.h>
#include "debug_uart.h"

static md_uart_init_t s_uart;

static void uart_pin_init(void)
{
    md_gpio_init_t l_gpio;

    l_gpio.type  = MD_GPIO_TYPE_CMOS;
    l_gpio.mode  = MD_GPIO_MODE_OUTPUT;
    l_gpio.odos  = MD_GPIO_PUSH_PULL;
    l_gpio.pupd  = MD_GPIO_PUSH_UP;
    l_gpio.podrv = MD_GPIO_OUT_DRIVE_1;
    l_gpio.nodrv = MD_GPIO_OUT_DRIVE_1;
    l_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    l_gpio.func  = DEBUG_UART_TX_GPIO_FUNC;
    md_gpio_init(DEBUG_UART_TX_GPIO_PORT, DEBUG_UART_TX_GPIO_PIN, &l_gpio);   /*Initializes the TX pin*/

    l_gpio.mode  = MD_GPIO_MODE_INPUT;
    l_gpio.func  = DEBUG_UART_RX_GPIO_FUNC;
    md_gpio_init(DEBUG_UART_RX_GPIO_PORT, DEBUG_UART_RX_GPIO_PIN, &l_gpio);
}

///重定向c库函数printf到串口，重定向后可使用printf函数
int fputc(int c, FILE *f)   /*Redirect printf output to the serial port*/
{
    while ((md_uart_is_active_flag_tfempty(DEBUG_UART_PERH)) != SET) ;   /*Waiting on the completion of a byte*/

    md_uart_set_send_data8(DEBUG_UART_PERH, (uint8_t)c);    /*UART send*/

    return c;
}

void debug_uart_init(void)
{
    uart_pin_init();

    s_uart.mode        = MD_UART_MODE;
    s_uart.baud        = 115200;
    s_uart.word_length = MD_UART_WORD_LENGTH_8B;
    s_uart.stop_bits   = MD_UART_STOP_BITS_1;
    s_uart.parity      = MD_UART_PARITY_NONE;
    s_uart.fctl        = MD_UART_FLOW_CTL_DISABLE;

    md_uart_init(DEBUG_UART_PERH, &s_uart);  /*Initialization and UART3, parameter 8 1 N 115200*/
}
