#include <stdio.h>
#include "debug_it.h"

void debug_it_init(void)
{
    /*uart */
    md_uart_set_rx_threshold(DEBUG_UART_PERH, MD_UART_RXFIFO_1BYTE);
    md_uart_enable_it_rfth(DEBUG_UART_PERH);

    DEBUG_UART_PERH->RTOR = 0x1000FFF;
    md_uart_enable_it_rxto(DEBUG_UART_PERH);

    md_mcu_irq_config(DEBUG_UART_IRQN, 0, 0, ENABLE);


    /*gpio exti*/
    md_gpio_set_interrupt_port(GPIOF, DEBUG_KEY1_GPIO_PIN);      /* set exit interrupt port */
#if DEBUG_KEY_ON
    md_gpio_enable_riging_edge_trigger(DEBUG_KEY1_GPIO_PIN); /* enable riging edge trigger */
#else
    md_gpio_enable_falling_edge_trigger(DEBUG_KEY1_GPIO_PIN);
#endif
    md_gpio_enable_external_interrupt(DEBUG_KEY1_GPIO_PIN);  /* enable exti10 */
    md_mcu_irq_config(DEBUG_KEY1_IRQN, 2, 2, ENABLE);       /* enable NVIC EXTI10_IRQn */

    md_gpio_set_interrupt_port(GPIOF, DEBUG_KEY2_GPIO_PIN);      /* set exit interrupt port */
#if DEBUG_KEY_ON
    md_gpio_enable_riging_edge_trigger(DEBUG_KEY2_GPIO_PIN); /* enable riging edge trigger */
#else
    md_gpio_enable_falling_edge_trigger(DEBUG_KEY2_GPIO_PIN);
#endif
    md_gpio_enable_external_interrupt(DEBUG_KEY2_GPIO_PIN);  /* enable exti10 */
    md_mcu_irq_config(DEBUG_KEY2_IRQN, 2, 2, ENABLE);       /* enable NVIC EXTI10_IRQn */


}
