#include "debug_gpio.h"

void debug_gpio_init(void)
{
    md_gpio_init_t l_gpio;

    l_gpio.func  = MD_GPIO_FUNC_1;
    l_gpio.type  = MD_GPIO_TYPE_CMOS;
    l_gpio.mode  = MD_GPIO_MODE_OUTPUT;
    l_gpio.odos  = MD_GPIO_PUSH_PULL;
    l_gpio.pupd  = MD_GPIO_PUSH_UP;
    l_gpio.podrv = MD_GPIO_OUT_DRIVE_6;
    l_gpio.nodrv = MD_GPIO_OUT_DRIVE_6;
    l_gpio.flt   = MD_GPIO_FILTER_DISABLE;
    md_gpio_init(DEBUG_LED1_GPIO_PORT, DEBUG_LED1_GPIO_PIN, &l_gpio);   /*LED*/
    md_gpio_init(DEBUG_LED2_GPIO_PORT, DEBUG_LED2_GPIO_PIN, &l_gpio);

    l_gpio.mode  = MD_GPIO_MODE_INPUT;
    md_gpio_init(DEBUG_KEY1_GPIO_PORT, DEBUG_KEY1_GPIO_PIN, &l_gpio);   /*KEY*/
    md_gpio_init(DEBUG_KEY2_GPIO_PORT, DEBUG_KEY2_GPIO_PIN, &l_gpio);
}

uint8_t Key_Scan(GPIO_TypeDef *GPIOx, uint16_t GPIO_Pin)
{
    /*检测是否有按键按下 */
    if (md_gpio_get_input_data(GPIOx, GPIO_Pin) == DEBUG_KEY_OFF)
    {
        /*等待按键释放 */
        while (md_gpio_get_input_data(GPIOx, GPIO_Pin) == DEBUG_KEY_OFF) {}

        return  1;
    }
    else
        return 0;
}