/**********************************************************************************
 *
 * @file    md_conf.h
 * @brief   Enable/Disable the peripheral module.
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021/09/03      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __USER_CHIP_CONFIG_H__
#define __USER_CHIP_CONFIG_H__

/* Exported Macros ----------------------------------------------------------- */

/*LiteOS 的部分参数*/

/*芯片工作的时钟频率，请根据实际配置填写*/
#define  CHIP_CONF_SYS_CLK              72000000

/*芯片外设相关参数*/
/*UART*/

#define DEBUG_UART_TX_GPIO_PORT         GPIOB
#define DEBUG_UART_TX_GPIO_PIN          MD_GPIO_PIN_10
#define DEBUG_UART_TX_GPIO_FUNC         MD_GPIO_FUNC_3

#define DEBUG_UART_RX_GPIO_PORT         GPIOB
#define DEBUG_UART_RX_GPIO_PIN          MD_GPIO_PIN_11
#define DEBUG_UART_RX_GPIO_FUNC         MD_GPIO_FUNC_3

#define DEBUG_UART_PERH                 UART0
#define DEBUG_UART_IRQ_HANDLER          UART0_Handler
#define DEBUG_UART_IRQN                 UART0_IRQn

/*LED*/

#define DEBUG_LED1_GPIO_PORT                 GPIOC
#define DEBUG_LED1_GPIO_PIN                  MD_GPIO_PIN_6

#define DEBUG_LED2_GPIO_PORT                 GPIOC
#define DEBUG_LED2_GPIO_PIN                  MD_GPIO_PIN_12

/*KEY*/

#define DEBUG_KEY_ON                         1
#define DEBUG_KEY_OFF                        0

#define DEBUG_KEY1_GPIO_PORT                 GPIOF
#define DEBUG_KEY1_GPIO_PIN                  MD_GPIO_PIN_0
#define DEBUG_KEY1_IRQ_HANDLER               EXTI0_Handler
#define DEBUG_KEY1_IRQN                      EXTI0_IRQn

#define DEBUG_KEY2_GPIO_PORT                 GPIOF
#define DEBUG_KEY2_GPIO_PIN                  MD_GPIO_PIN_6
#define DEBUG_KEY2_IRQ_HANDLER               EXTI6_Handler
#define DEBUG_KEY2_IRQN                      EXTI6_IRQn

/* Includes ------------------------------------------------------------------ */

#include "es32f36xx.h"

/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */

#endif /*__MD_CONF_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
