/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021/09/03      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "md_utils.h"

#include "los_sem.h"
#include "los_queue.h"

/* Private Macros ------------------------------------------------------------ */
/* Private Constants --------------------------------------------------------- */
/* Private function prototypes ----------------------------------------------- */
/* Private Variables --------------------------------------------------------- */
/* Public Variables ---------------------------------------------------------- */

static uint32_t s_send_data1 = 1;
static uint32_t s_send_data2 = 2;

uint8_t *g_rx_buf_p = &g_Uart_Rx_Buf[0];

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}


/**
  * @brief  EXTI0 handler
  * @retval None
  */
void DEBUG_KEY1_IRQ_HANDLER(void)
{
    UINTPTR uvIntSave;

    uvIntSave = LOS_IntLock();      /* 关中断 */

    /* exti0 interrupt */
    if (md_gpio_is_enabled_external_interrupt(DEBUG_KEY1_GPIO_PIN)
            && md_gpio_get_flag(DEBUG_KEY1_GPIO_PIN))
    {
        md_gpio_clear_flag(DEBUG_KEY1_GPIO_PIN);       /* clear exit0 interrupt flag */

        /* 将数据写入（发送）到队列中，等待时间为 0  */
        LOS_QueueWrite(g_Test_Queue_Handle,  /* 写入（发送）队列的ID(句柄) */
                       &s_send_data1,                /* 写入（发送）的数据 */
                       sizeof(s_send_data1), /* 数据的长度 */
                       0);                                 /* 等待时间为 0  */

    }

    LOS_IntRestore(uvIntSave);  /* 开中断 */
}

/**
  * @brief  EXTI6 handler
  * @retval None
  */
void DEBUG_KEY2_IRQ_HANDLER(void)
{
    UINTPTR uvIntSave;

    uvIntSave = LOS_IntLock();      /* 关中断 */

    /* exti6 interrupt */
    if (md_gpio_is_enabled_external_interrupt(DEBUG_KEY2_GPIO_PIN)
            && md_gpio_get_flag(DEBUG_KEY2_GPIO_PIN))
    {
        md_gpio_clear_flag(DEBUG_KEY2_GPIO_PIN);       /* clear exit6 interrupt flag */

        /* 将数据写入（发送）到队列中，等待时间为 0  */
        LOS_QueueWrite(g_Test_Queue_Handle,  /* 写入（发送）队列的ID(句柄) */
                       &s_send_data2,                /* 写入（发送）的数据 */
                       sizeof(s_send_data2), /* 数据的长度 */
                       0);                                 /* 等待时间为 0  */

    }

    LOS_IntRestore(uvIntSave);  /* 开中断 */
}

void DEBUG_UART_IRQ_HANDLER(void)
{
    UINTPTR uvIntSave;

    uvIntSave = LOS_IntLock();      /* 关中断 */

    if (md_uart_mask_it_rfth(DEBUG_UART_PERH))
    {
        md_uart_clear_flag_rfth(DEBUG_UART_PERH);

        while (!md_uart_is_active_flag_rfempty(DEBUG_UART_PERH))
        {
            * g_rx_buf_p = DEBUG_UART_PERH->RXBUF;
            g_rx_buf_p++;
        }
    }

    if (md_uart_mask_it_rxto(DEBUG_UART_PERH))
    {
        md_uart_clear_flag_rxto(DEBUG_UART_PERH);

        g_rx_buf_p = &g_Uart_Rx_Buf[0];

        /* 给出二值信号量 ，发送接收到新数据标志，供前台程序查询 */
        LOS_SemPost(g_BinarySem_Handle);   /* 给出二值信号量 xSemaphore */
    }

    LOS_IntRestore(uvIntSave);  /* 开中断 */
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
