/**********************************************************************************
 *
 * @file    main.h
 * @brief   Header file for DEMO
 *
 * @date    30 Apri 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    yanght          the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __MAIN_H__
#define   __MAIN_H__

/* Includes ------------------------------------------------------------------ */
#include "md_conf.h"
/* LiteOS 头文件 */
#include "los_sys.h"
#include "los_task.ph"
#include "los_queue.h"
#include "los_sem.h"
/* Exported Macros ----------------------------------------------------------- */
#define UART_RBUF_SIZE 1024
/* Exported Types ------------------------------------------------------------ */
/* Exported Variables -------------------------------------------------------- */
extern uint8_t g_Uart_Rx_Buf[UART_RBUF_SIZE];

/* 定义消息队列的句柄 */
extern UINT32 g_Test_Queue_Handle;

/* 外部定义二值信号量的句柄 */
extern UINT32 g_BinarySem_Handle;

/* Exported Constants -------------------------------------------------------- */
/* Exported Functions -------------------------------------------------------- */

#endif /*__MAIN_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
