/**********************************************************************************
 *
 * @file    irq.c
 * @brief   Interrupt handler
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.29      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include "md_utils.h"
#include "main.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  MemManage IRQ handler
  * @retval None
  */
void MemManage_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  BusFault IRQ handler
  * @retval None
  */
void BusFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  UsageFault IRQ handler
  * @retval None
  */
void UsageFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

void DMA_Handler(void)
{
    if (md_dma_is_enabled_it_done(MD_DMA_CH_0) && md_dma_is_active_flag_done(MD_DMA_CH_0))
    {
        md_dma_clear_flag_done(MD_DMA_CH_0);

        if (g_es_lvgl_lcd_tx_num == 0)
        {
            g_es_lvgl_lcd_tx_complete = 1;
#if (ES_LVGL_USE_2_DISP_BUF)

            if (g_es_dma_flush_disp_drv)
                lv_disp_flush_ready(g_es_dma_flush_disp_drv);

#endif /* (ES_LVGL_USE_2_DISP_BUF)*/
        }
        else
        {
            g_lcd_spi_dma_tx_config.size = (g_es_lvgl_lcd_tx_num > 1024) ? 1024 : g_es_lvgl_lcd_tx_num;
            g_lcd_spi_dma_tx_config.src = g_es_lvgl_lcd_tx_buf;

            md_dma_config_base(DMA0, MD_DMA_CYCLE_CTRL_BASIC, &g_lcd_spi_dma_tx_config);

            md_dma_enable_channel(MD_DMA_CH_0);

            g_es_lvgl_lcd_tx_num -= g_lcd_spi_dma_tx_config.size;
            g_es_lvgl_lcd_tx_buf += g_lcd_spi_dma_tx_config.size;
        }
    }

    return;
}

void ES_TOUCH_INT_IRQ_HANDLER(void)
{
    /* exti interrupt */
    if (md_gpio_is_enabled_external_interrupt(ES_TOUCH_INT_PIN_MD_PIN) && md_gpio_get_flag(ES_TOUCH_INT_PIN_MD_PIN))
    {
        md_gpio_clear_flag(ES_TOUCH_INT_PIN_MD_PIN);

        es_lvgl_gt91x_touch_read();
    }

    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    lv_tick_inc(1);

    return;
}
/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
