/**********************************************************************************
 *
 * @file    .c
 * @brief
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "stdio.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */
static lv_disp_draw_buf_t s_draw_buf_dsc;
static lv_color_t s_draw_buf_1[ES_LVGL_EACH_COLOR_DISP_BUF_SIZE];                        /*A buffer for n rows*/
#if (ES_LVGL_USE_2_DISP_BUF)
    static lv_color_t s_draw_buf_2[ES_LVGL_EACH_COLOR_DISP_BUF_SIZE];                        /*An other buffer for n rows*/
#endif /*(ES_LVGL_USE_2_DISP_BUF)*/
static lv_disp_drv_t s_es_disp_drv;                    /*Descriptor of a display driver*/
static lv_indev_drv_t s_indev_drv;
static lv_coord_t s_indev_x = 0;
static lv_coord_t s_indev_y = 0;
static lv_indev_state_t s_indev_state = LV_INDEV_STATE_RELEASED;


/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

static void touch_read(lv_indev_drv_t *s_indev_drv, lv_indev_data_t *data)
{
    data->state   = s_indev_state;
    data->point.x = s_indev_x;
    data->point.y = s_indev_y;
}

void es_lvgl_gt91x_touch_read(void)
{
    uint8_t touch_state;
    struct es_touch_data touch_data;

    touch_state = gt911_touch_scan(&touch_data, 1);

    if (touch_state)
    {
        s_indev_state = LV_INDEV_STATE_PR;
        s_indev_x = touch_data.x_coordinate;
        s_indev_y = touch_data.y_coordinate;
    }
    else
    {
        s_indev_state = LV_INDEV_STATE_REL;
    }
}

void lv_port_disp_init(void)
{

#if (ES_LVGL_USE_2_DISP_BUF)
    lv_disp_draw_buf_init(&s_draw_buf_dsc, s_draw_buf_1, s_draw_buf_2, ES_LVGL_EACH_COLOR_DISP_BUF_SIZE);   /*Initialize the display buffer*/
#else
    lv_disp_draw_buf_init(&s_draw_buf_dsc, s_draw_buf_1, NULL, ES_LVGL_EACH_COLOR_DISP_BUF_SIZE);   /*Initialize the display buffer*/
#endif /*(ES_LVGL_USE_2_DISP_BUF)*/

    lv_disp_drv_init(&s_es_disp_drv);                    /*Basic initialization*/

    /*Set the resolution of the display*/
    s_es_disp_drv.hor_res = ES_LVGL_LCD_DISP_HOR_RES;
    s_es_disp_drv.ver_res = ES_LVGL_LCD_DISP_VER_RES;

    /*Used to copy the buffer's content to the display*/
    s_es_disp_drv.flush_cb = es_lv_st7789_write_area;

    /*Set a display buffer*/
    s_es_disp_drv.draw_buf = &s_draw_buf_dsc;

    /*Finally register the driver*/
    lv_disp_drv_register(&s_es_disp_drv);
}

void lv_port_indev_init(void)
{
    lv_indev_drv_init(&s_indev_drv);
    s_indev_drv.type = LV_INDEV_TYPE_POINTER;
    s_indev_drv.read_cb = touch_read;
    lv_indev_drv_register(&s_indev_drv);
}

void es_lvgl_init(void)
{
#if LV_USE_LOG
#warning "need lv_log_register_print_cb()"
#endif /* LV_USE_LOG */
    lv_init();
    lv_port_disp_init();
    lv_port_indev_init();
}

/*MicroLIB 中无以下函数。LVGL的二维码生成代码中调用*/
__attribute__((weak, noreturn))
void __aeabi_assert(const char *expr, const char *file, int line)
{
    char str[12], *p;

    fputs("*** assertion failed: ", stderr);
    fputs(expr, stderr);
    fputs(", file ", stderr);
    fputs(file, stderr);
    fputs(", line ", stderr);

    p = str + sizeof(str);
    *--p = '\0';
    *--p = '\n';

    while (line > 0)
    {
        *--p = '0' + (line % 10);
        line /= 10;
    }

    fputs(p, stderr);

    abort();
}

__attribute__((weak))
void abort(void)
{
    for (;;);
}
