/**********************************************************************************
 *
 * @file    .h
 * @brief   Header file
 *
 * @date
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2022.11.30      liuhy           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef __ESSEMI_GT91X_H__
#define __ESSEMI_GT91X_H__

/* Includes ------------------------------------------------------------------ */
#include "es_example_conf.h"

/* Exported Types ------------------------------------------------------------ */
struct es_touch_data
{
    uint32_t timestamp;
    uint8_t track_id;
    uint16_t x_coordinate;
    uint16_t y_coordinate;
    uint16_t width;
};

/* Exported Macros ----------------------------------------------------------- */
#define ES_GT911_I2C_RADDR 0xBB
#define ES_GT911_I2C_WADDR 0xBA

#define   ES_MAX_TOUCH_POINT_NUM      (0x5)  /*输出触点个数上限： 1~10*/
#define   ES_TOUCH_INT_PERIOD         (0xF)  /*坐标上报率(周期为 5+N ms),N的范围：0~0xF*/
#define   ES_TOUCH_INT_MODE           (0x01)  /*INT 触发方式:    00 上升沿触发
                                                                 01 下降沿触发
                                                                 02 低电平查询
                                                                 03 高电平查询*/
#define   ES_TOUCH_SCREEN_POINT_CTRL_LEVEL1    (0x40)  /*屏上触摸点从无到有的阈值,范围：0~0xFF*/
#define   ES_TOUCH_SCREEN_POINT_CTRL_LEVEL2    (0x40)  /*屏上触摸点从有到无的阈值,范围：0~0xFF*/
#define   ES_TOUCH_CTRL_X2Y           (0U)   /*X,Y坐标交换,范围：0,1*/
#define   ES_TOUCH_MAX_X_VALUE        (240U)   /*X 坐标输出最大值,范围：0~0xFFFF*/
#define   ES_TOUCH_MAX_Y_VALUE        (320U)   /*Y 坐标输出最大值,范围：0~0xFFFF*/

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */
void gt911_touch_default_config(void);
void gt911_init(void);
void gt911_touch_reset(void);

uint8_t gt911_touch_scan(void *buf, uint32_t read_num);
uint8_t es_touch_gt911_read_data(uint16_t addr, uint8_t cnt, uint8_t *value);

#endif /*__ESSEMI_GT91X_H__*/
