/**
  *********************************************************************************
  *
  * @file    bsp_led.h
  * @brief   LED&KEY for debug
  *
  * @version V1.0
  * @date    12 Aug 2021
  * @author  shiwa
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Aug 2021     shiwa           The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __BSP_LED_H__
#define   __BSP_LED_H__

/* Includes ---------------------------------------------------------------- */

#include "md_conf.h"

/* Exported Types ---------------------------------------------------------- */

/* Exported Macros ----------------------------------------------------------- */

/* LED pins */
#define LED_PORT GPIOF
#define LED1_PIN MD_GPIO_PIN_0
#define LED2_PIN MD_GPIO_PIN_1

/* KEY pins */
#define KEY_PORT GPIOC
#define KEY_PIN  MD_GPIO_PIN_10

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */

/**
  * @brief  Initialize LED1/2 and KEY
  * @retval None
  */
extern void init_led(void);

#endif /* _BSP_LED_H */
