/**
  *********************************************************************************
  *
  * @file    bsp_led.c
  * @brief   LED&KEY gpio pin initialize code
  *
  * @version V1.0
  * @date    12 Aug 2021
  * @author  AE Team
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Aug 2021     shiwa           The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

/* Includes ----------------------------------------------------------------- */

#include "bsp_led.h"

/* Private Macros ----------------------------------------------------------- */

/* Public Variables -------------------------------------------------------- */

/* Private Variables--------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function---------------------------------------------------------- */
/**
  * @brief  Initialize LED1/2 and KEY
  * @retval None
  */
void init_led(void)
{
    md_gpio_init_t gpio_init;

    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.podrv = MD_GPIO_OUT_DRIVE_6;
    gpio_init.nodrv = MD_GPIO_OUT_DRIVE_6;
    gpio_init.func  = MD_GPIO_FUNC_1;
    md_gpio_init(LED_PORT, LED1_PIN, &gpio_init);
    md_gpio_init(LED_PORT, LED2_PIN, &gpio_init);

    md_gpio_set_pin_high(LED_PORT, LED1_PIN);
    md_gpio_set_pin_high(LED_PORT, LED2_PIN);

    /* Initialize KEY pin */
    md_gpio_init_struct(&gpio_init);      /* initialize the gpio_init */
    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    gpio_init.pupd  = MD_GPIO_FLOATING;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.func  = MD_GPIO_FUNC_1;
    md_gpio_init(KEY_PORT, KEY_PIN, &gpio_init);

}
