/**
  *********************************************************************************
  *
  * @file    bsp_uart.h
  * @brief   UART for debug printf
  *
  * @version V1.0
  * @date    12 Aug 2021
  * @author  shiwa
  * @note
  *          Change Logs:
  *          Date            Author          Notes
  *          12 Aug 2021     shiwa           The first version
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  * SPDX-License-Identifier: Apache-2.0
  *
  * Licensed under the Apache License, Version 2.0 (the License); you may
  * not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  * www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an AS IS BASIS, WITHOUT
  * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  **********************************************************************************
  */

#ifndef   __BSP_UART_H__
#define   __BSP_UART_H__
/* Includes ---------------------------------------------------------------- */
#include "md_conf.h"
#include <stdio.h>

/* Exported Types ---------------------------------------------------------- */

/* Exported Macros ----------------------------------------------------------- */

/* UART0 config & pins */
#define M_UART UART0
#define M_UART_BAUD 115200
#define M_UART_TX_PORT GPIOB
#define M_UART_TX_PIN MD_GPIO_PIN_10
#define M_UART_TX_FUNC MD_GPIO_FUNC_3
#define M_UART_RX_PORT GPIOB
#define M_UART_RX_PIN MD_GPIO_PIN_11
#define M_UART_RX_FUNC MD_GPIO_FUNC_3
#define M_UART_HANDLER UART0_handler
#define M_UART_IRQ UART0_IRQn


/* Exported Variables -------------------------------------------------------- */

/* Exported Constants ------------------------------------------------------- */

/* Exported Functions ------------------------------------------------------ */

/**
  * @brief  Init UART0 for printf/scanf
  * @retval None
  */
extern void init_uart(void);

#endif /* _BSP_UART_H_ */
