/**********************************************************************************
 *
 * @file    uart.c
 * @brief   Main file for DEMO
 *
 * @date    12 June 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          12 June 2023    shicc           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */

#include <stdio.h>
#include "uart.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

static md_uart_init_t s_uart;

/* Public Variables ---------------------------------------------------------- */

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

static void init_uart_pin(void);

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  uart function
  * @retval None.
  */
void init_mcu_uart(void)
{
    init_uart_pin();

    s_uart.mode        = MD_UART_MODE;
    s_uart.baud        = 115200;
    s_uart.word_length = MD_UART_WORD_LENGTH_8B;
    s_uart.stop_bits   = MD_UART_STOP_BITS_1;
    s_uart.parity      = MD_UART_PARITY_NONE;
    s_uart.fctl        = MD_UART_FLOW_CTL_DISABLE;

    md_uart_init(UART2, &s_uart);  /*Initialization and UART3, parameter 8 1 N 115200*/
}

/**
  * @brief  uart pin function
  * @retval None.
  */
static void init_uart_pin(void)
{
    md_gpio_init_t gpio_init;

    gpio_init.func  = MD_GPIO_FUNC_3;
    gpio_init.type  = MD_GPIO_TYPE_CMOS;
    gpio_init.mode  = MD_GPIO_MODE_OUTPUT;
    gpio_init.odos  = MD_GPIO_PUSH_PULL;
    gpio_init.pupd  = MD_GPIO_PUSH_UP;
    gpio_init.podrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.nodrv = MD_GPIO_OUT_DRIVE_1;
    gpio_init.flt   = MD_GPIO_FILTER_DISABLE;
    md_gpio_init(GPIOE, MD_GPIO_PIN_2, &gpio_init);   /*Initializes the TX pin*/

    gpio_init.mode  = MD_GPIO_MODE_INPUT;
    md_gpio_init(GPIOE, MD_GPIO_PIN_3, &gpio_init);   /*Apart from the pin direction for input configuration is the same as the TX pin*/
}

#ifdef __GNUC__     /* GCC Compiler */
int _write(int file, const void *ptr, int len)
{
    uint16_t cnt; 
    (void)file;
    uint8_t *ptr_char = (uint8_t *)ptr;

    int i = 0;

    for (i = 0 ; i < len ; i++)
    {
        if (*ptr_char == '\n')
        {
            cnt = 4000;
            while (!md_uart_is_active_flag_tfempty(UART2) && (--cnt));

            md_uart_set_send_data8(UART2, '\r');
        }

        cnt = 4000;
        while (!md_uart_is_active_flag_tfempty(UART2) && (--cnt));

        md_uart_set_send_data8(UART2, *ptr_char++);
    }

    return len;
}

void *_sbrk(intptr_t increment)
{
    extern char end asm("end");
    /* Defined by the linker. */
    static char *heap_end;
    char* prev_heap_end;
    heap_end += increment;

    return (void *)prev_heap_end;
}

void _read()
{

}

void _lseek()
{

}

void _close()
{

}

void _fstat()
{

}

void _isatty()
{

}

void _getpid()
{

}

void _kill()
{

}

void _exit()
{

}

#else
int fputc(int c, FILE *f)
{
    uint16_t cnt = 4000U;

    while (!md_uart_is_active_flag_tfempty(UART2) && (--cnt))
    {

    }

    md_uart_set_send_data8(UART2, c);

    return c;
}

#endif /* __GNUC__ */

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
