/**********************************************************************************
 *
 * @file    spi_flash.h
 * @brief   Header file for DEMO
 *
 * @date    12 June 2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          12 June 2023    shicc           the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__

/* Includes ------------------------------------------------------------------ */

#include "md_utils.h"
#include "md_spi.h"
#include "md_gpio.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#define SPI_NSS_PORT  GPIOB
#define SPI_NSS_PIN   MD_GPIO_PIN_0
#define SPI_SCK_PORT  GPIOD
#define SPI_SCK_PIN   MD_GPIO_PIN_3
#define SPI_MOSI_PORT GPIOB
#define SPI_MOSI_PIN  MD_GPIO_PIN_5
#define SPI_MISO_PORT GPIOB
#define SPI_MISO_PIN  MD_GPIO_PIN_4

#define FLASH_CS_SET()  (md_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 1))
#define FLASH_CS_CLR()  (md_gpio_write_pin(SPI_NSS_PORT, SPI_NSS_PIN, 0))

#define DUMMY_BYTE          0xFF
/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

void init_mcu_spi(void);

md_status_t spi_flash_write(const uint8_t* write_buf, size_t write_size);
md_status_t spi_flash_read(uint8_t* read_buf, size_t read_size);

#endif    /*__FLASH_H__*/


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
