/**********************************************************************************
 *
 * @file    spi_flash.h
 * @brief   Header file for DEMO
 *
 * @date    07 Dec 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          07 Dec 2021     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __FLASH_H__
#define   __FLASH_H__

/* Includes ------------------------------------------------------------------ */

#include "utils.h"
#include "ald_conf.h"

/* Exported Types ------------------------------------------------------------ */

/* Exported Macros ----------------------------------------------------------- */
#define SEC_SIZE        4096
#define BLK_SIZE        16   /* 16 sectors */
#define DEV_SIZE        128  /* 128 blocks */

/* Exported Variables -------------------------------------------------------- */

/* Exported Constants -------------------------------------------------------- */

/* Exported Functions -------------------------------------------------------- */

ald_status_t ll_spi_flash_init(void);
ald_status_t ll_flash_sector_erase(uint32_t start_sec, uint32_t end_sec);
ald_status_t ll_flash_sector_write(const uint8_t *src_buf, uint32_t sec, uint32_t sec_num);
ald_status_t ll_flash_sector_read(uint8_t *str_buf, uint32_t sec, uint32_t sec_num);

#endif    /*__FLASH_H__*/

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
