/**********************************************************************************
 *
 * @file    main.c
 * @brief   Main file for DEMO
 *
 * @date    07 Dec 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          07 Dec 2021     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

/* Includes ------------------------------------------------------------------ */
#include "main.h"
#include "string.h"

/* Private Macros ------------------------------------------------------------ */


/* Public Variables ---------------------------------------------------------- */
uint8_t g_wtext[50] = "Ϻز΢޹˾";    /* File write buffer */
uint8_t g_rtext[50];                                   /* File read buffer */

BYTE    g_work[FF_MAX_SS];
FATFS   g_micro_sd_fatfs;         /* File system object for NAND flash volume */
FIL     g_test_file[2];           /* File object */
uint8_t g_micro_sd_path[20] = {0};
uint8_t g_filepath[20];

/* Private Constants --------------------------------------------------------- */


/* Private Variables--------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */
void led_pin_init(void);
void error_handler(void);

/* Private functions ---------------------------------------------------------*/


/**
  * @brief  Main program
  * @param  None
  * @retval None
  */
int main(void)
{
    FRESULT res;
    uint32_t byteswritten, bytesread;                     /* File write/read counts */

    /* Initialize ALD */
    ald_cmu_init();
    /* Configure system clock */
    ald_cmu_pll1_config(CMU_PLL1_INPUT_HOSC_3, CMU_PLL1_OUTPUT_72M);
    ald_cmu_clock_config(CMU_CLOCK_PLL1, 72000000);
    ald_cmu_perh_clock_config(CMU_PERH_ALL, ENABLE);

    /* Init LED6 and LED7 */
    led_pin_init();

    /* Regeister the NAND Flash disk I/O driver */
    if (FATFS_LinkDriverEx(&micro_sd_drv, (char *)g_micro_sd_path, 0) == 0)
    {
        /* Register the file system object to the FatFs module */
        if (f_mount(&g_micro_sd_fatfs, (const TCHAR *)g_micro_sd_path, 0) != FR_OK)
        {
            /* FatFs Initialization Error */
            error_handler();
        }
        else
        {
            /* Create FAT volume on the logical drive 0 */
            if (f_mkfs((const TCHAR *)g_micro_sd_path, FM_ANY, 0, g_work, sizeof(g_work)))
            {
                error_handler();
            }
            else
            {
                memcpy(g_micro_sd_path + 3, "ESSEMI.TXT", 10);

                /* Create and Open a new text file object with write access */
                if (f_open(g_test_file, (const TCHAR *)g_micro_sd_path, FA_CREATE_ALWAYS | FA_WRITE) != FR_OK)
                {
                    /* 'ESSEMI.TXT' file Open for write Error */
                    error_handler();
                }
                else
                {
                    /* Write data to the text file */
                    res = f_write(g_test_file, (const void *)g_wtext, sizeof(g_wtext), &byteswritten);

                    if ((byteswritten == 0) || (res != FR_OK))
                    {
                        /* 'ESSEMI.TXT' file Write or EOF Error */
                        error_handler();
                    }
                    else
                    {
                        /* Close the open text file */
                        if (f_close(g_test_file) != FR_OK)
                        {
                            error_handler();
                        }

                        if (f_open(g_test_file, (const TCHAR *)g_micro_sd_path, FA_READ) != FR_OK)
                        {
                            /* 'ESSEMI.TXT' file Open for read Error */
                            error_handler();
                        }
                        else
                        {
                            /* Read data from the text file */
                            res = f_read(g_test_file, g_rtext, sizeof(g_rtext), (UINT *)&bytesread);

                            if ((bytesread == 0) || (res != FR_OK)) /* EOF or Error */
                            {
                                /* 'ESSEMI.TXT' file Read or EOF Error */
                                error_handler();
                            }
                            else
                            {
                                /* Close the open text file */
                                f_close(g_test_file);

                                /* Compare read data with the expected data */
                                if ((bytesread != byteswritten) || (memcmp(g_wtext, g_rtext, sizeof(g_wtext))))
                                {
                                    /* Read data is different from the expected data */
                                    error_handler();
                                }
                                else
                                {
                                    /* Success of the demo: no error occurrence */
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /* unmount */
    if (f_mount((void *)0, (const TCHAR *)g_micro_sd_path, 0) != FR_OK)
    {
        /* FatFs Initialization Error */
        error_handler();
    }

    /* mount again */
    if (f_mount(&g_micro_sd_fatfs, (const TCHAR *)g_micro_sd_path, 0) != FR_OK)
    {
        /* FatFs Initialization Error */
        error_handler();
    }

    if (f_open(g_test_file, (const TCHAR *)g_micro_sd_path, FA_READ) != FR_OK)
    {
        /* 'ESSEMI.TXT' file Open for read Error */
        error_handler();
    }
    else
    {
        /* Read data from the text file */
        res = f_read(g_test_file, g_rtext, sizeof(g_rtext), (UINT *)&bytesread);

        if ((bytesread == 0) || (res != FR_OK)) /* EOF or Error */
        {
            /* 'ESSEMI.TXT' file Read or EOF Error */
            error_handler();
        }
        else
        {
            memcpy(g_filepath, g_micro_sd_path, 3);
            memcpy(g_filepath, "READ.TXT", sizeof("READ.TXT"));

            if (f_open(g_test_file + 1, (const TCHAR *)g_filepath, FA_CREATE_ALWAYS | FA_WRITE) != FR_OK)
            {
                error_handler();
            }

            f_write(g_test_file + 1, (const void *)g_rtext, sizeof(g_rtext), &byteswritten);
            /* Close the open text file */
            f_close(g_test_file);
            f_close(g_test_file + 1);
        }
    }

    /* unmount */
    if (f_mount((void *)0, (const TCHAR *)g_micro_sd_path, 0) != FR_OK)
    {
        /* FatFs Initialization Error */
        error_handler();
    }

    /* Unlink the micro sd I/O driver */
    FATFS_UnLinkDriverEx((char *)g_micro_sd_path, 0);

    /* Infinite loop */
    while (1)
    {
        ald_gpio_toggle_pin(GPIOC, GPIO_PIN_6);
        ald_delay_ms(1000);
    }
}

/**
  * @brief  LED pin init.
  * @param  None
  * @retval None
  */
static void led_pin_init(void)
{
    gpio_init_t gpio_config;
    memset(&gpio_config, 0x0, sizeof(gpio_config)); /* initialize the gpio_init */
    gpio_config.mode  = GPIO_MODE_OUTPUT;
    gpio_config.odos  = GPIO_PUSH_PULL;
    gpio_config.pupd  = GPIO_PUSH_UP;
    gpio_config.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.podrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.flt   = GPIO_FILTER_DISABLE;
    gpio_config.type  = GPIO_TYPE_TTL;
    gpio_config.func  = GPIO_FUNC_1;

    /* Init for LED6 and LED7 */
    ald_gpio_init(GPIOC, GPIO_PIN_6, &gpio_config);
    ald_gpio_init(GPIOC, GPIO_PIN_7, &gpio_config);
    ald_gpio_write_pin(GPIOC, GPIO_PIN_6, 1);
    ald_gpio_write_pin(GPIOC, GPIO_PIN_7, 1);
}

/**
  * @brief  This function is executed in case of error occurrence.
  * @param  None
  * @retval None
  */
static void error_handler(void)
{
    while (1)
    {
        /* Flash LED7 per 1S */
        ald_gpio_toggle_pin(GPIOC, GPIO_PIN_7);
        ald_delay_ms(1000);
    }
}

/**
  * @}
  */
/**
  * @}
  */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
