/**********************************************************************************
 *
 * @file    nand.h
 * @brief   Header file for nand.c
 *
 * @date    12 Nov 2021
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          12 Nov 2021     biyq            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */

#ifndef   __NAND_FLASH_H__
#define   __NAND_FLASH_H__

/* Includes ------------------------------------------------------------------ */
#include "ald_conf.h"

/* Exported Macros ----------------------------------------------------------- */


/* Exported Variables -------------------------------------------------------- */


/* Exported Constants -------------------------------------------------------- */


/* Exported Types ---------------------------------------------------------- */


/* Exported Functions ------------------------------------------------------ */
uint8_t ll_nand_flash_init(void);
uint8_t ll_nand_flash_read(uint8_t *, uint32_t, uint32_t);
uint8_t ll_nand_flash_write(const uint8_t *, uint32_t, uint32_t);
uint8_t ll_nand_flash_erase(uint32_t, uint32_t);
void    ll_block_scope_get(uint32_t, uint32_t *, uint32_t *);

#endif  /* __NAND_FLASH_H__ */


/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
