/**********************************************************************************
 *
 * @file    main.c
 * @brief   main file for SWD-Printf sample project
 *
 * @version V1.0
 * @date    2021.07.05
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021.03.04      lvzd            the 1st version
 *          2021.07.05      biyq            the 2nd version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include <string.h>
#include <math.h>
#include "main.h"
#include "essemi_swd_print.h"

/* Private Macros ----------------------------------------------------------- */
#define PRINT_STR       0
/* Private Variables -------------------------------------------------------- */

/* Public Variables --------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private Function Prototypes ---------------------------------------------- */

/* Private Function --------------------------------------------------------- */

/**
  * @brief  main function
  * @param  None
  * @retval None
  */
int main(void)
{
    uint32_t i = 0;
    int32_t data2send[2];
    float   f_data2send;

    /* 配置系统时钟 */
    md_cmu_pll1_config(MD_CMU_PLL1_INPUT_HOSC_3, MD_CMU_PLL1_OUTPUT_96M);
    md_cmu_clock_config(MD_CMU_CLOCK_PLL1, 96000000);

    /* 使能外设时钟 */
    SYSCFG_UNLOCK();
    md_cmu_enable_perh_all();
    SYSCFG_LOCK();

    /* 初始化缓冲区 */
    essemi_swd_configupbuffer(0, "SWDUP", NULL, 0, ESSEMI_SWD_MODE_BLOCK_IF_FIFO_FULL);
    essemi_swd_configdownbuffer(0, "SWDDOWN", NULL, 0, ESSEMI_SWD_MODE_BLOCK_IF_FIFO_FULL);

#if (PRINT_STR)
    ESSEMI_SWD_SetTerminal(0);
    essemi_swd_printf(0, "%s", "SWD print demo\r\n");
#endif

    while (1)
    {
        /* 数组赋值 */
        data2send[0] = (int32_t)(100 * sin((2 * 3.1415926 / 4095) * i));
        f_data2send = 100 * sin((2 * 3.1415926 / 4095) * i) + 20;

        /* 设置终端号 */
        ESSEMI_SWD_SetTerminal(0);
        /* 向SWD端口缓冲区输出数据，注意输出的第一个字符必须为空格，并根据数据位宽将数据格式输出 */
        essemi_swd_printf(0, " %d", data2send[0]);
        ESSEMI_SWD_SetTerminal(1);
        essemi_swd_printf(0, " %8.4f", f_data2send);

        i++;
    }
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
