/**********************************************************************************
 *
 * @file    irq.c
 * @brief   interrupt request handler
 *
 * @version V1.0
 * @date    2021.03.04
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          2021.03.04      lvzd            the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 **********************************************************************************
 */

/* Includes ----------------------------------------------------------------- */

#include "main.h"
#include "md_utils.h"

/* Private Macros ----------------------------------------------------------- */

/* Private Variables -------------------------------------------------------- */

/* Public Variables --------------------------------------------------------- */

/* Private Constants -------------------------------------------------------- */

/* Private function prototypes ---------------------------------------------- */

/* Private Function --------------------------------------------------------- */

/**
  * @brief  NMI IRQ handler
  * @retval None
  */
void NMI_Handler(void)
{
    /* Added Emergency operation */
    return;
}

/**
  * @brief  Hardfault IRQ handler
  * @retval None
  */
void HardFault_Handler(void)
{
    /* Added debug information */
    while (1)
        ;
}

/**
  * @brief  Supervisor Call IRQ handler
  * @retval None
  */
void SVC_Handler(void)
{
    /* Added system callback */
    return;
}

/**
  * @brief  Debug Monitor IRQ handler
  * @retval None
  */
void DebugMon_Handler(void)
{
    /* Added debug operation */
    return;
}

/**
  * @brief  PendSV IRQ handler
  * @retval None
  */
void PendSV_Handler(void)
{
    /* Added thread switching operation */
    return;
}

/**
  * @brief  SysTick IRQ handler
  * @retval None
  */
void SysTick_Handler(void)
{
    md_inc_tick();
    return;
}

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
