/**********************************************************************************
 *
 * @file    iir_test.c
 * @brief   IIR test
 *
 * @date    09 Feb  2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 Feb  2023    AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
/* Includes ------------------------------------------------------------------ */
#include <stdio.h>
#include "es32_dsp.h"

/* Private Macros ------------------------------------------------------------ */

/* Private Constants --------------------------------------------------------- */
/* 
 * sample_freq=50
 * input=2*sin(5*t*2*pi/50)+sin(12*t*2*pi/50)+1 
 **/
 
/* Shape=(512,) */
const uint16_t IIR_DATA[512]={
16384,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16383,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16383,16760,9756,4196,8592,14687,13852,13569,21199,27779,24575,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16384,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8191,4988,11568,19198,18915,18080,24175,28571,23011,16007,16384,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8191,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16383,16760,9756,4196,8592,14687,13852,13569,21199,27779,24575,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8191,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16384,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24575,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16384,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
21199,21761,13852,6495,8592,12388,9756,8568,16383,24199,23011,20379,24175,26272,18915,11006,
11568,13180,8192,4988,11568,19198,18915,18080,24175,28571,23011,16007,16383,16760,9756,4196,
8592,14687,13852,13569,21199,27779,24576,19587,21199,21761,13852,6495,8592,12388,9756,8568,
16383,24199,23011,20379,24175,26272,18915,11006,11568,13180,8192,4988,11568,19198,18915,18080,
24175,28571,23011,16007,16384,16760,9756,4196,8592,14687,13852,13569,21199,27779,24576,19587,
};

/* Butterworth 8-order band pass filter [2,8] (Fixed point: 12) */
/* Shape=(4, 5) */
const int16_t IIR_COEF[20]={
-4057,1479,36,73,36,
-6253,2552,4096,8192,4096,
-3792,2714,4096,-8192,4096,
-7453,3614,4096,-8192,4096,
};

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */
static uint16_t s_iir_output[512];

/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */
void iir_test(void)
{
	iir_biquad_fixed(s_iir_output,IIR_DATA,IIR_COEF,512);
	printf("IIR\r\n");
    for (int i=0;i<512;i++)
    {
        printf("%d\r\n",s_iir_output[i]);
    }
}
