/**********************************************************************************
 *
 * @file    fft_test.c
 * @brief   FFT test
 *
 * @date    09 Feb  2023
 * @author  AE Team
 * @note
 *          Change Logs:
 *          Date            Author          Notes
 *          09 Feb  2023    AE Team         the first version
 *
 * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 **********************************************************************************
 */
 
/* Includes ------------------------------------------------------------------ */
#include "stdio.h"
#include "es32_dsp.h"

/* Private Macros ------------------------------------------------------------ */
#define TEST_LEN 256

/* Private Constants --------------------------------------------------------- */
const int16_t TEST_FFT_INPUT[]={
            0,   6825,  -3829,  13346,   2093,   7760,  12940,    254,
        15144,   1491,   4796,   7800,  -6737,   6737,  -7800,  -4796,
        -1491, -15144,   -254, -12940,  -7760,  -2093, -13346,   3829,
        -6825,      0,   6825,  -3829,  13346,   2093,   7760,  12940,
          254,  15144,   1491,   4796,   7800,  -6737,   6737,  -7800,
        -4796,  -1491, -15144,   -254, -12940,  -7760,  -2093, -13346,
         3829,  -6825,      0,   6825,  -3829,  13346,   2093,   7760,
        12940,    254,  15144,   1491,   4796,   7800,  -6737,   6737,
        -7800,  -4796,  -1491, -15144,   -254, -12940,  -7760,  -2093,
       -13346,   3829,  -6825,      0,   6825,  -3829,  13346,   2093,
         7760,  12940,    254,  15144,   1491,   4796,   7800,  -6737,
         6737,  -7800,  -4796,  -1491, -15144,   -254, -12940,  -7760,
        -2093, -13346,   3829,  -6825,      0,   6825,  -3829,  13346,
         2093,   7760,  12940,    254,  15144,   1491,   4796,   7800,
        -6737,   6737,  -7800,  -4796,  -1491, -15144,   -254, -12940,
        -7760,  -2093, -13346,   3829,  -6825,      0,   6825,  -3829,
    
            0,   6825,  -3829,  13346,   2093,   7760,  12940,    254,
        15144,   1491,   4796,   7800,  -6737,   6737,  -7800,  -4796,
        -1491, -15144,   -254, -12940,  -7760,  -2093, -13346,   3829,
        -6825,      0,   6825,  -3829,  13346,   2093,   7760,  12940,
          254,  15144,   1491,   4796,   7800,  -6737,   6737,  -7800,
        -4796,  -1491, -15144,   -254, -12940,  -7760,  -2093, -13346,
         3829,  -6825,      0,   6825,  -3829,  13346,   2093,   7760,
        12940,    254,  15144,   1491,   4796,   7800,  -6737,   6737,
        -7800,  -4796,  -1491, -15144,   -254, -12940,  -7760,  -2093,
       -13346,   3829,  -6825,      0,   6825,  -3829,  13346,   2093,
         7760,  12940,    254,  15144,   1491,   4796,   7800,  -6737,
         6737,  -7800,  -4796,  -1491, -15144,   -254, -12940,  -7760,
        -2093, -13346,   3829,  -6825,      0,   6825,  -3829,  13346,
         2093,   7760,  12940,    254,  15144,   1491,   4796,   7800,
        -6737,   6737,  -7800,  -4796,  -1491, -15144,   -254, -12940,
        -7760,  -2093, -13346,   3829,  -6825,      0,   6825,  -3829
}; 

/* Private function prototypes ----------------------------------------------- */

/* Private Variables --------------------------------------------------------- */
static int16_t s_fft_input[TEST_LEN*2];
static int16_t s_fft_output[TEST_LEN*2+2];

/* Public Variables ---------------------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

void fft_test(void)
{
    for (int i=0;i<TEST_LEN;i++)
    {
        s_fft_input[i*2]=TEST_FFT_INPUT[i%256];
        s_fft_input[i*2+1]=0;
    }
    printf("FFT 256\r\n");
	cfft_r4_256(s_fft_output,s_fft_input,TEST_LEN);
    for (int i=0;i<TEST_LEN*2+2;i++)
    {
        printf("[%d]=%d\r\n",i,s_fft_output[i]);
    }
}
